<?php $__env->startSection('content'); ?>
<div class="card card-custom gutter-b">
	<div class="card-body">

		<div class="" id="kt_user_profile_aside" style="margin-left: 10px; margin-right: 10px;">

			<input type="hidden" id="_token" value="<?php echo e(csrf_token()); ?>">
			<form class="<?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInLeft" method="get" action="/empresas/filtro">
				<div class="row align-items-center">

					<div class="form-group col-lg-3 col-md-6 col-sm-6">
						<label class="col-form-label">Nome</label>
						<div class="">
							<div class="input-group date">
								<input type="text" name="nome" class="form-control" value="<?php echo e(isset($nome) ? $nome : ''); ?>" />
								
							</div>
						</div>
					</div>

					<div class="form-group col-lg-3 col-md-3 col-sm-3">
						<label class="col-form-label">Estado</label>
						<div class="">
							<select name="status" class="custom-select">
								<option <?php if(isset($status)): ?> <?php if($status == 'TODOS'): ?> selected <?php endif; ?> <?php endif; ?> value="TODOS">TODOS</option>
								<option <?php if(isset($status)): ?> <?php if($status == 1): ?> selected <?php endif; ?> <?php endif; ?> value="1">ATIVO</option>
								<option <?php if(isset($status)): ?> <?php if($status == 2): ?> selected <?php endif; ?> <?php endif; ?> value="2">PENDENTE</option>
								<option <?php if(isset($status)): ?> <?php if($status == '0'): ?> selected <?php endif; ?> <?php endif; ?> value="0">DESATIVADO</option>
							</select>
						</div>
					</div>

					<div class="form-group col-lg-2 col-md-3 col-sm-3">
						<label class="col-form-label">Plano</label>
						<div class="">
							<select name="plano" class="custom-select">
								<option <?php if(isset($plano)): ?> <?php if($plano == 'TODOS'): ?> selected <?php endif; ?> <?php endif; ?> value="TODOS">TODOS</option>
								<?php $__currentLoopData = $planos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<option <?php if(isset($plano)): ?> <?php if($plano == $p->id): ?> selected <?php endif; ?> <?php endif; ?> value="<?php echo e($p->id); ?>"><?php echo e($p->nome); ?></option>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</select>
						</div>
					</div>
					<div class="form-group col-lg-2 col-md-6 col-sm-6">
						<label class="col-form-label">Dias para expirar</label>
						<div class="">
							<div class="input-group date">
								<input type="text" name="dias_expirar" class="form-control" value="<?php echo e(isset($dias_expirar) ? $dias_expirar : ''); ?>" />
								
							</div>
						</div>
					</div>
					<div class="col-lg-2 col-xl-2 mt-2 mt-lg-0">
						<button style="margin-top: 15px;" class="btn btn-light-primary px-6 font-weight-bold">Pesquisa</button>
					</div>
				</div>
			</form>

			<div class="form-group validated col-12">
				<label class="col-form-label">DEBUG</label>
				<span class="switch switch-outline switch-danger">
					<label>
						<input value="true" <?php if(getenv("APP_DEBUG") == 'true'): ?> checked <?php endif; ?> type="checkbox" id="debug">
						<span></span>
					</label>
				</span>
			</div>

			<h4 class="<?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInRight">Lista de Empresas</h4>

			<label class="<?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInRight">Registros: <strong class="text-success"><?php echo e(sizeof($empresas)); ?></strong></label>
			<div class="col-xl-12 <?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInLeft">
				<div class="row">

					<a href="/empresas/nova" class="btn btn-success">
						<i class="la la-plus"></i>
						Nova Empresa
					</a>

					<?php if(isset($paraImprimir)): ?>
					<form method="post" action="/empresas/relatorio">
						<?php echo csrf_field(); ?>
						<input type="hidden" name="nome" value="<?php echo e(isset($nome) ? $nome : ''); ?>">
						<input type="hidden" name="status" value="<?php echo e(isset($status) ? $status : ''); ?>">
						<button style="margin-left: 5px;" class="btn btn-lg btn-info">
							<i class="fa fa-print"></i>Imprimir relatório
						</button>
					</form>
					<?php endif; ?>

				</div>
			</div>

			<div class="col-xl-12 <?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInRight">

				<div id="kt_datatable" class="datatable datatable-bordered datatable-head-custom datatable-default datatable-primary datatable-loaded">

					<table class="datatable-table" style="max-width: 100%; overflow: scroll">
						<thead class="datatable-head">
							<tr class="datatable-row" style="left: 0px;">
								<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 70px;">#</span></th>
								

								<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 120px;">Data cadastro</span></th>
								<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 150px;">Nome</span></th>
								<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 120px;">Telefone</span></th>
								<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Cidade</span></th>
								<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Plano</span></th>
								<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Status</span></th>
								<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 120px;">Representante</span></th>
								<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 120px;">Ultimo login</span></th>
								<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 150px;">Dias para expirar</span></th>
								<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 200px;">Ações</span></th>
							</tr>
						</thead>

						<tbody class="datatable-body">
							<?php $__currentLoopData = $empresas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

							<tr class="datatable-row">
								<td class="datatable-cell">
									<span class="codigo" style="width: 70px;">
										<?php echo e($e->id); ?>

									</span>
								</td>
								<td class="datatable-cell">
									<span class="codigo" style="width: 120px;">
										<?php echo e(\Carbon\Carbon::parse($e->created_at)->format('d/m/Y H:i')); ?>

									</span>
								</td>
								<td class="datatable-cell">
									<span class="codigo" style="width: 150px;">
										<?php echo e($e->nome); ?>

									</span>
								</td>

								<td class="datatable-cell">
									<span class="codigo" style="width: 120px;">
										<?php echo e($e->telefone); ?>

									</span>
								</td>

								<td class="datatable-cell">
									<span class="codigo" style="width: 100px;">
										<?php echo e($e->cidade); ?>

									</span>
								</td>

								<td class="datatable-cell">
									<span class="codigo" style="width: 100px;">
										<?php if($e->planoEmpresa): ?>
										<?php echo e($e->planoEmpresa->plano->nome); ?>

										<?php else: ?>
										--
										<?php endif; ?>
									</span>
								</td>

								<td class="datatable-cell">
									<span class="codigo" style="width: 100px;">
										<?php if($e->status() == -1): ?>
										<span class="label label-xl label-inline label-light-info">
											MASTER
										</span>

										<?php elseif($e->status() && $e->tempo_expira >= 0): ?>
										<span class="label label-xl label-inline label-light-success">
											ATIVO
										</span>
										<?php else: ?>

										<?php if(!$e->planoEmpresa): ?>
										<span class="label label-xl label-inline label-light-danger">
											DESATIVADO
										</span>
										<?php else: ?>
										<?php if($e->planoEmpresa->expiracao == '0000-00-00'): ?>
										<span class="label label-xl label-inline label-light-success">
											ATIVO
										</span>
										<?php else: ?>
										<span class="label label-xl label-inline label-light-danger">
											DESATIVADO
										</span>
										<?php endif; ?>
										<?php endif; ?>
										<?php endif; ?>

									</span>
								</td>

								<td class="datatable-cell">
									<span class="codigo" style="width: 120px;">
										<?php if($e->tipo_representante): ?>
										<span class="label label-xl label-inline label-light-success">
											SIM
										</span>

										<?php else: ?>
										<span class="label label-xl label-inline label-light-info">
											NÃO
										</span>
										<?php endif; ?>
									</span>
								</td>

								<td class="datatable-cell">
									<span class="codigo" style="width: 120px;">

										<?php if($e->ultimoLogin($e->id)): ?>
										<?php echo e(\Carbon\Carbon::parse(
											$e->ultimoLogin($e->id)->created_at)->format('d/m/Y H:i')); ?>

										<?php else: ?>
										--
										<?php endif; ?>
									</span>
								</td>

								<td class="datatable-cell">
									<span class="codigo" style="width: 150px;">
										<?php if($e->tempo_expira): ?>

										<?php if($e->planoEmpresa->expiracao == '0000-00-00'): ?>
										<span class="text-info">Indeterminado</span>
										<?php else: ?>
										<?php if($e->tempo_expira < 0): ?>
										<span class="text-danger">Vencido</span>

										<?php elseif($e->tempo_expira >= 0 && $e->tempo_expira < 5): ?>
										<span class="text-warning"><?php echo e($e->tempo_expira); ?></span>

										<?php else: ?>
										<span class="text-dark"><?php echo e($e->tempo_expira); ?></span>
										<?php endif; ?>
										<?php endif; ?>

										<?php else: ?>
										--
										<?php endif; ?>
									</span>
								</td>

								<td class="datatable-cell">
									<span class="codigo" style="width: 280px;">
										<a href="/empresas/detalhes/<?php echo e($e->id); ?>" class="btn btn-sm btn-primary">
											Detalhes
										</a>

										<?php if(!$e->isMaster()): ?>
										<a onclick='swal("Atenção!", "Deseja remover esta empresa?", "warning").then((sim) => {if(sim){ location.href="/empresas/verDelete/<?php echo e($e->id); ?>" }else{return false} })' href="#!"  class="btn btn-sm btn-danger">
											Remover
										</a>
										<?php endif; ?>

										<?php if($e->status): ?>
										<a href="/empresas/alterarStatus/<?php echo e($e->id); ?>" class="btn btn-sm btn-warning">
											Bloquear
										</a>
										<?php else: ?>
										<a href="/empresas/alterarStatus/<?php echo e($e->id); ?>" class="btn btn-sm btn-success">
											Desbloquear
										</a>
										<?php endif; ?>
									</span>
								</td>
							</tr>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
</div>

<?php $__env->startSection('javascript'); ?>
<script type="text/javascript">
	$('#debug').click(() => {
		location.href="/empresas/alteraDebug"
	})
</script>
<?php $__env->stopSection(); ?>	

<?php $__env->stopSection(); ?>	

<?php echo $__env->make('default.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nextsistemas/nextweb.nextsistemas.app.br/resources/views/empresas/list.blade.php ENDPATH**/ ?>