<?php $__env->startSection('content'); ?>

<div class="single_product">
	<div class="container">
		<div class="row">
			<!-- Images -->
			<div class="col-lg-2 order-lg-1 order-2">
				<ul class="image_list">
					
					<?php $__currentLoopData = $produto->galeria; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $g): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<li data-image="/ecommerce/produtos/<?php echo e($g->img); ?>"><img src="/ecommerce/produtos/<?php echo e($g->img); ?>" alt=""></li>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</ul>
			</div>

			<!-- Selected Image -->
			<div class="col-lg-5 order-lg-2 order-1">
				<div class="image_selected"><img src="/ecommerce/produtos/<?php echo e($produto->galeria[0]->img); ?>" alt=""></div>
			</div>

			<!-- Description -->
			<div class="col-lg-5 order-3">
				<div class="product_description">
					<div class="product_category"><?php echo e($produto->categoria->nome); ?></div>
					<div class="product_name"><?php echo e($produto->produto->nome); ?></div>
					<br>
					<div class="text-truncate" style="height: 40px;">
						<?php echo $produto->descricao; ?>

					</div>
					<div class="order_info d-flex flex-row">
						<form method="post" action="<?php echo e($rota); ?>/addProduto">
							<?php echo csrf_field(); ?>
							<input type="hidden" value="<?php echo e($default['config']->empresa_id); ?>" name="empresa_id">
							<div class="clearfix" style="z-index: 1000;">
								<input type="hidden" value="<?php echo e($produto->id); ?>" name="produto_id">


								<!-- Product Quantity -->
								<div class="product_quantity clearfix">
									<span>Quantidade: </span>
									<input name="quantidade" id="quantity_input" type="text" pattern="[0-9]*" value="1">
									<div class="quantity_buttons">
										<div id="quantity_inc_button" class="quantity_inc quantity_control"><i class="fas fa-chevron-up"></i></div>
										<div id="quantity_dec_button" class="quantity_dec quantity_control"><i class="fas fa-chevron-down"></i></div>
									</div>
								</div>
							</div>

							<div class="product_price">R$ <?php echo e(number_format($produto->valor, 2, ',', '.')); ?></div>
							<div class="button_container">
								<button type="submit" class="button cart_button">
									Adicionar ao carrinho
								</button>
								<div class="product_fav"><i class="fas fa-heart"></i></div>
							</div>

						</form>
					</div>
				</div>
			</div>


		</div>
		<br><br>
		<div class="row"> 
			<?php echo $produto->descricao; ?>

		</div>

	</div>
</div>

<div class="viewed">
	<div class="container">
		<div class="row">
			<div class="col">
				<div class="viewed_title_container">
					<h3 class="viewed_title">Produtos da categoria</h3>
					<div class="viewed_nav_container">
						<div class="viewed_nav viewed_prev"><i class="fas fa-chevron-left"></i></div>
						<div class="viewed_nav viewed_next"><i class="fas fa-chevron-right"></i></div>
					</div>
				</div>

				<div class="viewed_slider_container">
					
					<!-- Recently Viewed Slider -->

					<div class="owl-carousel owl-theme viewed_slider">
						
						<!-- Recently Viewed Item -->

						<?php $__currentLoopData = $categoria->produtos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

						<?php if($p->id != $produto->id && sizeof($p->galeria) > 0): ?>
						<div class="owl-item">
							<div class="viewed_item discount d-flex flex-column align-items-center justify-content-center text-center">
								<a href="<?php echo e($rota); ?>/<?php echo e($p->id); ?>/verProduto">
									<div class="viewed_image">
										<img src="/ecommerce/produtos/<?php echo e($p->galeria[0]->img); ?>" alt="">
									</div>
									<div class="viewed_content text-center">
										<div class="viewed_price">R$ 
											<?php echo e(number_format($p->valor, 2, ',', '.')); ?>

											<span>
												<?php echo e(number_format($p->valor + ($p->valor *($p->percentual_desconto_view/100)), 2, ',', '.')); ?>

											</span>
										</div>
										<div class="viewed_name">
											<a href="#">
												<?php echo e($p->produto->nome); ?>

											</a>
										</div>
									</div>
									<ul class="item_marks">
										<!-- <li class="item_mark item_discount">-25%</li> -->

										<?php if($p->isNovo()): ?>
										<li class="item_mark item_new">Novo</li>
										<?php endif; ?>

									</ul>
								</a>

							</div>
						</div>
						<?php endif; ?>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('ecommerce_one_tech.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcosbueno/Documents/laravel/metronic_multi_8.4/resources/views/ecommerce_one_tech/produto_view.blade.php ENDPATH**/ ?>