<?php $__env->startSection('content'); ?>
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
	<div class="container">
		<div class="card card-custom gutter-b example example-compact">
			<div class="col-lg-12">
				<form method="post" action="<?php echo e(isset($produto) ? '/produtoEcommerce/update': '/produtoEcommerce/save'); ?>" enctype="multipart/form-data">
					<input type="hidden" name="id" value="<?php echo e(isset($produto->id) ? $produto->id : 0); ?>">
					<input type="hidden" id="subs" value="<?php echo e(json_encode($subs)); ?>">

					<div class="card card-custom gutter-b example example-compact">
						<div class="card-header">

							<h3 class="card-title"><?php echo e(isset($produto) ? 'Editar' : 'Novo'); ?> Produto</h3>
						</div>

					</div>
					<?php echo csrf_field(); ?>

					<div class="row">
						<div class="col-xl-12">
							<div class="kt-section kt-section--first">
								<div class="kt-section__body">
									<p class="text-danger">>> O produto de ecommerce depende do produto principal, isso é necessário para baixa de estoque e emissão fiscal</p>
									<div class="row">
										<div <?php if(old('produto') != ""): ?> style="display: none" <?php endif; ?> id="ref-prod" class="form-group validated col-sm-7 col-lg-6 col-10">
											<label class="col-form-label" id="">Produto</label><br>
											<select  <?php if(isset($produto)): ?> disabled <?php endif; ?> class="form-control select2 <?php if($errors->has('produto_id')): ?> is-invalid <?php endif; ?>" style="width: 100%" id="kt_select2_1" name="produto_id">
												<option value="null">Selecione o produto</option>
												<?php $__currentLoopData = $produtos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<option 
												<?php if(isset($produto)): ?>
												<?php if($p->id == $produto->produto->id): ?>
												selected
												<?php endif; ?>

												<?php else: ?>

												<?php if(old('produto_id') == $p->id): ?>
												selected
												<?php endif; ?>

												<?php endif; ?>
												value="<?php echo e($p->id); ?>"><?php echo e($p->id); ?> - <?php echo e($p->nome); ?></option>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
											</select>
											<?php if($errors->has('produto_id')): ?>
											<div class="invalid-feedback">
												<?php echo e($errors->first('produto_id')); ?>

											</div>
											<?php endif; ?>

											
										</div>

										<div <?php if(old('produto') == ""): ?> style="display: none" <?php endif; ?> id="novo-prod" class="form-group validated col-sm-5 col-lg-6 col-12">
											<label class="col-form-label">Nome do Produto</label>
											<div class="">
												<input value="<?php echo e(old('produto')); ?>" type="text" class="form-control <?php if($errors->has('produto')): ?> is-invalid <?php endif; ?>" name="produto" id="produto" >
												<?php if($errors->has('produto')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('produto')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

										<?php if(!isset($produto)): ?>
										<div class="col-lg-1 col-md-1 col-sm-1 col-2">
											<br>
											<a id="novo-produto" style="margin-top: 18px;" class="btn btn-success">
												<i class="la la-plus"></i>
											</a>
										</div>
										<?php endif; ?>

										<div class="form-group validated col-lg-3 col-md-4 col-sm-10">
											<label class="col-form-label">Categoria</label>

											<select id="categoria-select" class="custom-select form-control" name="categoria_id">
												<?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<option
												<?php if($c->id == old('categoria_id')): ?>
												selected=""
												<?php endif; ?>

												<?php if(isset($produto)): ?>
												<?php if($c->id == $produto->categoria_id): ?>
												selected=""
												<?php endif; ?>
												<?php endif; ?>
												value="<?php echo e($c->id); ?>"><?php echo e($c->nome); ?></option>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
											</select>

											<?php if($errors->has('categoria')): ?>
											<div class="invalid-feedback">
												<?php echo e($errors->first('categoria')); ?>

											</div>
											<?php endif; ?>
										</div>
									</div>
									<div class="row">
										
										<div class="form-group validated col-lg-3 col-md-6 col-sm-10">
											<label class="col-form-label">Sub Categoria</label>
											<div class="input-group">

												<select id="sub_categoria_id" class="form-control custom-select" name="sub_categoria_id">
													<option value="">--</option>
												</select>

												<?php if($errors->has('sub_categoria_id')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('sub_categoria_id')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>


										<input type="hidden" id="sub_id" value="<?php if(isset($produto)): ?> <?php echo e($produto->sub_categoria_id); ?> <?php else: ?> 0 <?php endif; ?>" name="">


										<div class="form-group validated col-sm-4 col-lg-3">
											<label class="col-form-label">Valor</label>
											<div class="">
												<input type="text" class="form-control <?php if($errors->has('valor')): ?> is-invalid <?php endif; ?>" name="valor" id="valor" value="<?php echo e(isset($produto) ? $produto->valor : old('valor')); ?>">
												<?php if($errors->has('valor')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('valor')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

										<div class="form-group validated col-sm-4 col-lg-3">
											<label class="col-form-label">% desconto exibição</label>
											<div class="">
												<input data-mask="00" type="text" class="form-control <?php if($errors->has('percentual_desconto_view')): ?> is-invalid <?php endif; ?>" name="percentual_desconto_view" id="percentual_desconto_view" value="<?php echo e(isset($produto) ? $produto->percentual_desconto_view : old('percentual_desconto_view')); ?>">
												<?php if($errors->has('percentual_desconto_view')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('percentual_desconto_view')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

										<div class="col col-sm-3 col-lg-3">
											<br>
											<label>Controlar estoque:</label>

											<div class="switch switch-outline switch-success">
												<label class="">
													<input <?php if(isset($produto->controlar_estoque) && $produto->controlar_estoque): ?> checked <?php else: ?>
													<?php if(old('controlar_estoque')): ?> checked <?php endif; ?> <?php endif; ?> value="true" name="controlar_estoque" class="red-text" type="checkbox">
													<span class="lever"></span>
												</label>
											</div>
										</div>

										<div class="col col-sm-3 col-lg-3">
											<br>
											<label>Ativo:</label>

											<div class="switch switch-outline switch-info">
												<label class="">
													<input <?php if(isset($produto->status) && $produto->status): ?> checked <?php else: ?>
													<?php if(old('status')): ?> checked <?php endif; ?> <?php endif; ?> value="true" name="status" class="red-text" type="checkbox">
													<span class="lever"></span>
												</label>
											</div>
										</div>

										<div class="col col-sm-3 col-lg-3">
											<br>
											<label>Destaque:</label>

											<div class="switch switch-outline switch-primary">
												<label class="">
													<input <?php if(isset($produto->destaque) && $produto->destaque): ?> checked <?php else: ?>
													<?php if(old('destaque')): ?> checked <?php endif; ?> <?php endif; ?> value="true" name="destaque" class="red-text" type="checkbox">
													<span class="lever"></span>
												</label>
											</div>
										</div>

										<div class="form-group validated col-lg-3 col-md-3 col-sm-4">
											<label class="col-form-label">Largura (cm)</label>

											<input type="text" id="largura" class="form-control <?php if($errors->has('largura')): ?> is-invalid <?php endif; ?>" name="largura" 
											value="<?php echo e(isset($produto) ? $produto->produto->largura : old('largura')); ?>">
										</div>

										<div class="form-group validated col-lg-3 col-md-3 col-sm-4">
											<label class="col-form-label">Altura (cm)</label>

											<input type="text" id="altura" class="form-control <?php if($errors->has('altura')): ?> is-invalid <?php endif; ?>" name="altura" 
											value="<?php echo e(isset($produto) ? $produto->produto->altura : old('altura')); ?>">
										</div>

										<div class="form-group validated col-lg-3 col-md-3 col-sm-4">
											<label class="col-form-label">Comprimento (cm)</label>

											<input type="text" id="comprimento" class="form-control <?php if($errors->has('comprimento')): ?> is-invalid <?php endif; ?>" name="comprimento" value="<?php echo e(isset($produto) ? $produto->produto->comprimento : old('comprimento')); ?>">
										</div>


										<div class="form-group validated col-lg-3 col-md-3 col-sm-4">
											<label class="col-form-label">Peso liquido</label>

											<input type="text" id="peso_liquido" class="form-control <?php if($errors->has('peso_liquido')): ?> is-invalid <?php endif; ?>" name="peso_liquido" 
											value="<?php echo e(isset($produto) ? $produto->produto->peso_liquido : old('peso_liquido')); ?>">
										</div>

										<div class="form-group validated col-lg-3 col-md-3 col-sm-4">
											<label class="col-form-label">Peso bruto</label>

											<input type="text" id="peso_bruto" class="form-control <?php if($errors->has('peso_bruto')): ?> is-invalid <?php endif; ?>" name="peso_bruto" 
											value="<?php echo e(isset($produto) ? $produto->produto->peso_bruto : old('peso_bruto')); ?>">
										</div>

										<?php if(getenv("CEP_PRODUTO_ECOMMERCE") == 1): ?>
										<div class="form-group validated col-lg-3 col-md-3 col-sm-4">
											<label class="col-form-label">CEP</label>

											<input type="text" id="cep" class="form-control <?php if($errors->has('cep')): ?> is-invalid <?php endif; ?>" name="cep" 
											value="<?php echo e(isset($produto) ? $produto->cep : old('cep')); ?>">
										</div>
										<?php endif; ?>

									</div>


									<div class="row">
										<div class="form-group validated col-sm-12 col-lg-12">
											<label class="col-form-label">Descrição</label>
											<div class="">

												<div class="row">
													<div class="col-12">
														<textarea name="descricao" id="descricao" style="width:100%;height:500px;"><?php echo e(isset($produto) ? $produto->descricao : old('descricao')); ?></textarea>
													</div>
												</div>

												<?php if($errors->has('descricao')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('descricao')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>
									</div>

									<?php if(!isset($produto)): ?>
									<div class="row">
										<div class="form-group validated col-sm-4 col-lg-4 col-6">
											<label class="col-xl-12 col-lg-12 col-form-label text-left">Imagem </label>
											<div class="col-lg-10 col-xl-6">

												<div class="image-input image-input-outline" id="kt_image_1">
													<div class="image-input-wrapper"
													<?php if(isset($produto) && file_exists(public_path('ecommerce/produtos/').$produto->galeria[0]->path)): ?> style="background-image: url(/ecommerce/produtos/<?php echo e($produto->galeria[0]->img); ?>)" <?php else: ?> style="background-image: url(/imgs/no_image.png)" <?php endif; ?>
													></div>
													<label class="btn btn-xs btn-icon btn-circle btn-white btn-hover-text-primary btn-shadow" data-action="change" data-toggle="tooltip" title="" data-original-title="Change avatar">
														<i class="fa fa-pencil icon-sm text-muted"></i>
														<input type="file" name="file" accept=".png, .jpg">
														<input type="hidden" name="profile_avatar_remove">
													</label>
													<span class="btn btn-xs btn-icon btn-circle btn-white btn-hover-text-primary btn-shadow" data-action="cancel" data-toggle="tooltip" title="" data-original-title="Cancel avatar">
														<i class="fa fa-close icon-xs text-muted"></i>
													</span>
												</div>


												<span class="form-text text-muted">.png</span>
												<?php if($errors->has('file')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('file')); ?>

												</div>
												<?php endif; ?>
												<span class="text-danger">*Recomendado 600x600</span>
											</div>
										</div>
									</div>
									<?php endif; ?>

								</div>
							</div>


						</div>
					</div>
					<div class="card-footer">

						<div class="row">
							<div class="col-xl-2">

							</div>
							<div class="col-lg-3 col-sm-6 col-md-4">
								<a style="width: 100%" class="btn btn-danger" href="/deliveryCategoria">
									<i class="la la-close"></i>
									<span class="">Cancelar</span>
								</a>
							</div>
							<div class="col-lg-3 col-sm-6 col-md-4">
								<button style="width: 100%" type="submit" class="btn btn-success">
									<i class="la la-check"></i>
									<span class="">Salvar</span>
								</button>
							</div>

						</div>
					</div>

				</form>
			</div>
		</div>
	</div>

	<?php $__env->startSection('javascript'); ?>
	<script type="text/javascript">

		var PRODUTONOVO = false;
		var SUBCATEGORIAS = []
		$(function () {
			SUBCATEGORIAS = JSON.parse($('#subs').val())
			setTimeout(() => {
				montaSubs()
				let sub_id = $('#sub_id').val()
				if(sub_id > 0){
					sub_id = parseInt(sub_id)
					$('#sub_categoria_id').val(sub_id).change()
				}
			}, 300)

		});

		$('#categoria-select').change(() => {
			montaSubs()
		})

		function montaSubs(){
			let categoria_id = $('#categoria-select').val()
			let subs = SUBCATEGORIAS.filter((x) => {
				return x.categoria_id == categoria_id
			})

			let options = ''
			subs.map((s) => {
				options += '<option value="'+s.id+'">'
				options += s.nome
				options += '</option>'
			})
			$('#sub_categoria_id').html('<option value="">--</option>')
			$('#sub_categoria_id').append(options)
		}
		$('#kt_select2_1').change(() => {
			let uri = window.location.pathname;
			if(uri.split('/')[2] != 'apontamentoManual' && uri.split('/')[2] != 'receita'){
				let id = $('#kt_select2_1').val()
				getProduto(id, (data) => {
					if(!data.ecommerce){
						$('#valor').val(parseFloat(data.valor_venda).toFixed(casas_decimais))
						$('#largura').val(data.largura)
						$('#altura').val(data.altura)
						$('#comprimento').val(data.comprimento)
						$('#peso_liquido').val(data.peso_liquido)
						$('#peso_bruto').val(data.peso_bruto)

						console.log(data)
					}else{
						swal('Erro', 'Este produto já possui cadastro no ecommerce', 'error')
						$('#kt_select2_1').val('null').change();
					}
				})
			}
		})

		function getProduto(id, data){
			$.ajax
			({
				type: 'GET',
				url: path + 'produtos/getProduto/'+id,
				dataType: 'json',
				success: function(e){
					data(e)
				}, error: function(e){
					console.log(e)
				}

			});
		}

		$('#novo-produto').click(() => {
			if(!PRODUTONOVO){
				$('#novo-prod').css('display', 'block')
				$('#ref-prod').css('display', 'none')
			}else{
				$('#novo-prod').css('display', 'none')
				$('#ref-prod').css('display', 'block')
			}

			PRODUTONOVO = !PRODUTONOVO
		})

	</script>
	<?php $__env->stopSection(); ?>
	<?php $__env->stopSection(); ?>
<?php echo $__env->make('default.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcosbueno/Documents/laravel/metronic_multi_8.4/resources/views/produtoEcommerce/register.blade.php ENDPATH**/ ?>