@extends('relatorios.cabecalho')
@section('content')
<div class="row">
	<div class="col s12">
		<h3 class="center-align">Relatório por CFOP {{$cfop}}</h3>
	</div>

	<table class="pure-table">
		<thead>
			<tr>
				<th width="400">PRODUTO</th>
				<th width="100">VALOR DE VENDA</th>
				<th width="100">VALOR DE COMPRA</th>
				<th width="100">CATEGORIA</th>
			</tr>
		</thead>

		<tbody>
			@foreach($produtos as $key => $p)
			<tr class="@if($key%2 == 0) pure-table-odd @endif">
				<td><center>{{$p->nome}}</center></td>
				<td><center>{{number_format($p->valor_venda, 2)}}</center></td>
				<td><center>{{number_format($p->valor_compra, 2)}}</center></td>
				<td><center>{{$p->categoria->nome}}</center></td>

			</tr>
			@endforeach
		</tbody>
	</table>

</div>
@endsection


