<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePlanoEmpresasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('plano_empresas', function (Blueprint $table) {
            $table->increments('id');

            $table->integer('empresa_id')->unsigned();
            $table->foreign('empresa_id')->references('id')
            ->on('empresas')->onDelete('cascade');

            $table->integer('plano_id')->unsigned();
            $table->foreign('plano_id')->references('id')
            ->on('planos')->onDelete('cascade');

            $table->date('expiracao');
            $table->string('mensagem_alerta', 255)->default('');

            // alter table plano_empresas add column mensagem_alerta varchar(255) default '';
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('plano_empresas');
    }
}
