<?php $__env->startSection('content'); ?>

<div class="card card-custom gutter-b">


	<div class="card-body">
		<div class="<?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInLeft">
			<div class="col-12">

				<div class="row">
					<a style="margin-left: 5px; margin-top: 5px;" href="/produtos/new" class="btn btn-lg btn-success">
						<i class="fa fa-plus"></i>Novo Produto
					</a>

					<?php if(isset($paraImprimir)): ?>
					<form method="post" action="/produtos/relatorio">
						<?php echo csrf_field(); ?>
						<input type="hidden" name="produto" value="<?php echo e(isset($produto) ? $produto : ''); ?>">
						<input type="hidden" name="categoria" value="<?php echo e($categoria); ?>">
						
						<input type="hidden" name="estoque" value="<?php echo e($estoque); ?>">
						<button style="margin-left: 5px; margin-top: 5px;" class="btn btn-lg btn-info">
							<i class="fa fa-print"></i>Imprimir relatório
						</button>
					</form>
					<?php endif; ?>

					<a style="margin-left: 5px; margin-top: 5px;" href="/produtos/importacao" class="btn btn-lg btn-danger">
						<i class="fa fa-arrow-up"></i>Importação
					</a>

					<a style="margin-left: 5px; margin-top: 5px;" href="/divisaoGrade" class="btn btn-lg btn-info">
						<i class="fa fa-th"></i>Divisao de Grade
					</a>

					<?php if(sizeof($produtos) > 0): ?>
					<a style="margin-left: 5px; margin-top: 5px;" href="/percentualuf" class="btn btn-lg btn-warning">
						<i class="fa fa-percent"></i>Tributação por estado
					</a>
					<?php endif; ?>
				</div>
			</div>
		</div>
		<br>

		<div class="<?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInRight" id="kt_user_profile_aside" style="margin-left: 10px; margin-right: 10px;">

			<form method="get" action="/produtos/filtroCategoria">
				<div class="row align-items-center">
					<div class="col-lg-3 col-xl-2">
						<div class="row align-items-center">
							<div class="col-md-12 my-2 my-md-0">
								<label>Tipo de pesquisa</label>
								<select class="form-control" name="tipo">
									<option <?php if(isset($tipo)): ?> <?php if($tipo == 'nome'): ?>
										selected
										<?php endif; ?>
										<?php endif; ?> value="nome">Nome</option>
									<option <?php if(isset($tipo)): ?> <?php if($tipo == 'referencia'): ?>
										selected
										<?php endif; ?>
										<?php endif; ?> value="referencia">Referência</option>
									<option <?php if(isset($tipo)): ?> <?php if($tipo == 'cod_barras'): ?>
										selected
										<?php endif; ?>
										<?php endif; ?> value="cod_barras">Código de barras</option>
								</select>
							</div>
						</div>
					</div>

					<div class="col-lg-4 col-xl-4">
						<div class="row align-items-center">
							<div class="col-md-12 my-2 my-md-0">
								<label>Produto</label>
								<div class="input-icon">
									<input type="text" name="pesquisa" class="form-control" value="<?php echo e(isset($pesquisa) ? $pesquisa : ''); ?>"
									placeholder="Produto..." id="kt_datatable_search_query">
									<span>
										<i class="fa fa-search"></i>
									</span>
								</div>
							</div>
						</div>
					</div>

					<div class="col-lg-3 col-xl-2">
						<div class="row align-items-center">
							<div class="col-md-12 my-2 my-md-0">
								<label>Categoria</label>
								<select class="form-control select2" id="kt_select2_1" name="categoria">
									<option value="-">Todas</option>
									<?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<option <?php if(isset($categoria)): ?> <?php if($c->id == $categoria): ?>
										selected
										<?php endif; ?>
										<?php endif; ?>
										value="<?php echo e($c->id); ?>"><?php echo e($c->nome); ?>

									</option>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</select>
							</div>
						</div>
					</div>

					<div class="col-lg-2 col-xl-2">
						<div class="row align-items-center">
							<div class="col-md-12 my-2 my-md-0">
								<label>Estoque</label>
								<select class="form-control custom-select" name="estoque">
									<option value="--">--</option>
									<option <?php if(isset($estoque) && $estoque == 1): ?> selected <?php endif; ?> value="1">Positivo</option>
									<option <?php if(isset($estoque) && $estoque == -1): ?> selected <?php endif; ?> value="-1">Negativo</option>
								</select>
							</div>
						</div>
					</div>

					<div class="col-lg-2 col-xl-2">
						<button style="margin-top: 25px;" type="submit" class="btn btn-light-primary font-weight-bold">Pesquisa</button>
					</div>
				</div>

			</form>

			<br>
			<h4>Lista de Produtos</h4>

			<?php if(!isset($categoria)): ?>
			<p>Média % de lucro todos os produtos: <strong><?php echo e(App\Models\Produto::mediaLucro()); ?></strong></p>

			<label>Total de produtos cadastrados: <strong class="text-info"><?php echo e(($totalGeralPrdutos)); ?></strong></label>
			<?php endif; ?>
			<p class="text-danger">Produtos em vermelho inativos</p>

			<div class="row">
				<div class="col-sm-12 col-lg-12 col-md-12 col-xl-12">


					<div class="wizard wizard-3" id="kt_wizard_v3" data-wizard-state="between" data-wizard-clickable="true">
						<!--begin: Wizard Nav-->

						<div class="wizard-nav">

							<div class="wizard-steps px-8 py-8 px-lg-15 py-lg-3">
								<!--begin::Wizard Step 1 Nav-->
								<div class="wizard-step" data-wizard-type="step" data-wizard-state="done">
									<div class="wizard-label">
										<h3 class="wizard-title">
											<span>
												<i style="font-size: 40px" class="la la-table"></i>
												Tabela
											</span>
										</h3>
										<div class="wizard-bar"></div>
									</div>
								</div>
								<!--end::Wizard Step 1 Nav-->
								<!--begin::Wizard Step 2 Nav-->
								<div class="wizard-step" data-wizard-type="step" data-wizard-state="current">
									<div class="wizard-label" id="grade">
										<h3 class="wizard-title">
											<span>
												<i style="font-size: 40px" class="la la-tablet"></i>
												Grade
											</span>
										</h3>
										<div class="wizard-bar"></div>
									</div>
								</div>

							</div>
						</div>

						<!-- inicio grid -->
						<div class="pb-5" data-wizard-type="step-content">
							<div class="row">
								<div class="col-xl-12">

									<div id="kt_datatable" class="datatable datatable-bordered datatable-head-custom datatable-default datatable-primary datatable-loaded">

										<table class="datatable-table" style="max-width: 100%; overflow: scroll">
											<thead class="datatable-head">
												<tr class="datatable-row" style="left: 0px;">
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 250px;">NOME</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">CATEGORIA</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">VALOR DE VENDA</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">VALOR DE COMPRA</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">% LUCRO</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">UN. COMPRA</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">UN. VENDA</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 120px;">DATA DE CADASTRO</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 120px;">GERENCIAR ESTOQUE</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 120px;">TIPO GRADE</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">ESTOQUE</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 250px;">AÇÕES</span></th>
												</tr>
											</thead>

											<tbody id="body" class="datatable-body">
												<?php $__currentLoopData = $produtos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<tr class="datatable-row" <?php if($p->inativo): ?> style="background: #ffcdd2;" <?php endif; ?>>
													<td class="datatable-cell"><span class="codigo" style="width: 250px;" id="id"><?php echo e($p->nome); ?></span>
													</td>
													<td class="datatable-cell"><span class="codigo" style="width: 100px;" id="id"><?php echo e($p->categoria->nome); ?></span>
													</td>

													<?php if($p->grade): ?>
													<td class="datatable-cell">
														<span class="codigo" style="width: 100px;" id="id">
														<?php echo e($p->valoresGrade()); ?>	
														</span>
													</td>
													<?php else: ?>
													<td class="datatable-cell"><span class="codigo" style="width: 100px;" id="id"><?php echo e(number_format($p->valor_venda, $casasDecimais, ',', '.')); ?></span>
													</td>
													<?php endif; ?>
													<td class="datatable-cell"><span class="codigo" style="width: 100px;" id="id"><?php echo e(number_format($p->valor_compra, $casasDecimais, ',', '.')); ?></span>
													</td>
													<td class="datatable-cell"><span class="codigo" style="width: 100px;" id="id"><?php echo e($p->percentual_lucro); ?>%</span>
													</td>
													<td class="datatable-cell"><span class="codigo" style="width: 100px;" id="id"><?php echo e($p->unidade_compra); ?></span>
													</td>
													<td class="datatable-cell"><span class="codigo" style="width: 100px;" id="id"><?php echo e($p->unidade_venda); ?></span>
													</td>
													<td class="datatable-cell"><span class="codigo" style="width: 120px;"><?php echo e(\Carbon\Carbon::parse($p->created_at)->format('d/m/Y H:i')); ?></span>
													</td>
													<td class="datatable-cell">
														<span class="codigo" style="width: 120px;" id="id">
															<?php if($p->gerenciar_estoque): ?>
															<span class="label label-xl label-inline label-success">Sim</span>
															<?php else: ?>
															<span class="label label-xl label-inline label-warning">Não</span>
															<?php endif; ?>
														</span>
													</td>

													<td class="datatable-cell">
														<span class="codigo" style="width: 120px;" id="id">
															<?php if($p->grade): ?>
															<span class="label label-xl label-inline label-success">Sim</span>
															<?php else: ?>
															<span class="label label-xl label-inline label-warning">Não</span>
															<?php endif; ?>
														</span>
													</td>

													<td class="datatable-cell">
														<span class="codigo" style="width: 100px;" id="id">
															<?php if($p->estoque): ?>
															<?php if($p->unidade_venda == 'UN' || $p->unidade_venda == 'UNID'): ?>
															<?php echo e(number_format($p->estoque_atual)); ?>

															<?php else: ?>
															<?php echo e($p->estoque_atual); ?>

															<?php endif; ?>

															<?php else: ?>
															0
															<?php endif; ?>
														</span>
													</td>

													<td class="datatable-cell">
														<span class="codigo" style="width: 300px;" id="id">
															<a title="Editar" class="btn btn-warning" onclick='swal("Atenção!", "Deseja editar este registro?", "warning").then((sim) => {if(sim){ location.href="/produtos/edit/<?php echo e($p->id); ?>" }else{return false} })' href="#!">
																<i class="la la-edit"></i>	
															</a>
															<a title="Remover" class="btn btn-danger" onclick='swal("Atenção!", "Deseja remover este registro?", "warning").then((sim) => {if(sim){ location.href="/produtos/delete/<?php echo e($p->id); ?>" }else{return false} })' href="#!">
																<i class="la la-trash"></i>	
															</a>
															<?php if($p->composto): ?>
															<a class="btn btn-primary" href="/produtos/receita/<?php echo e($p->id); ?>">
																<i class="la la-list"></i>	
															</a>
															<?php endif; ?>

															<?php if($p->grade): ?>
															<a title="Grade" class="btn btn-primary" href="/produtos/grade/<?php echo e($p->id); ?>">
																<i class="la la-th"></i>	
															</a>
															<?php endif; ?>

															<a title="Movimentação" class="btn btn-info" href="/produtos/movimentacao/<?php echo e($p->id); ?>">
																<i class="las la-tasks"></i>
															</a>

															<a title="Duplicar" class="btn btn-primary" onclick='swal("Atenção!", "Deseja duplicar este registro?", "warning").then((sim) => {if(sim){ location.href="/produtos/duplicar/<?php echo e($p->id); ?>" }else{return false} })' href="#!">
																<i class="la la-copy"></i>	
															</a>

															<?php if($p->ecommerce): ?>
															<a title="Ecommerce" title="Ecommerce" class="btn btn-info" href="/produtoEcommerce/edit/<?php echo e($p->ecommerce->id); ?>">
																<i class="la la-shopping-cart"></i>
															</a>
															<?php endif; ?>

															<a title="Gerar etiqueta(s)" class="btn btn-dark" href="/produtos/etiqueta/<?php echo e($p->id); ?>">
																<i class="la la-barcode"></i>
															</a>
														</span>
													</td>
												</tr>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
											</tbody>
										</table>

									</div>
								</div>
							</div>
						</div>
						<div class="pb-5" data-wizard-type="step-content">
							<div class="row">

								<?php $__currentLoopData = $produtos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

								<div class="col-sm-12 col-lg-6 col-md-6 col-xl-4">
									<div class="card card-custom gutter-b example example-compact">
										<div class="card-header">
											<div class="card-title">
												<div class="flex-shrink-0 mr-4 mt-lg-0 mt-3">
													<div class="symbol symbol-circle symbol-lg-75">
														<?php if($p->imagem != ''): ?>
														<img src="/imgs_produtos/<?php echo e($p->imagem); ?>" alt="image">
														<?php else: ?>
														<img src="/imgs/no_image.png" alt="image">
														<?php endif; ?>

													</div>
												</div>
												<h3 style="width: 230px; font-size: 12px; height: 10px;" class="card-title"><?php echo e(substr($p->nome, 0, 30)); ?>

												</h3>

												<div class="dropdown dropdown-inline" data-toggle="tooltip" title="" data-placement="left" data-original-title="Ações">
													<a href="#" class="btn btn-hover-light-primary btn-sm btn-icon" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
														<i class="fa fa-ellipsis-h"></i>
													</a>
													<div class="dropdown-menu p-0 m-0 dropdown-menu-md dropdown-menu-right">
														<!--begin::Navigation-->
														<ul class="navi navi-hover">
															<li class="navi-header font-weight-bold py-4">
																<span class="font-size-lg">Ações:</span>
															</li>
															<li class="navi-separator mb-3 opacity-70"></li>
															<li class="navi-item">
																<a href="/produtos/edit/<?php echo e($p->id); ?>" class="navi-link">
																	<span class="navi-text">
																		<span class="label label-xl label-inline label-light-primary">Editar</span>
																	</span>
																</a>
															</li>
															<li class="navi-item">
																<a onclick='swal("Atenção!", "Deseja remover este registro?", "warning").then((sim) => {if(sim){ location.href="/produtos/delete/<?php echo e($p->id); ?>" }else{return false} })' href="#!" class="navi-link">
																	<span class="navi-text">
																		<span class="label label-xl label-inline label-light-danger">Excluir</span>
																	</span>
																</a>
															</li>

															<?php if($p->composto): ?>
															<li class="navi-item">
																<a href="/produtos/receita/<?php echo e($p->id); ?>" class="navi-link">
																	<span class="navi-text">
																		<span class="label label-xl label-inline label-light-warning">Receita/Composição</span>
																	</span>
																</a>
															</li>
															<?php endif; ?>

															<?php if($p->grade): ?>
															<li class="navi-item">
																<a href="/produtos/grade/<?php echo e($p->id); ?>" class="navi-link">
																	<span class="navi-text">
																		<span class="label label-xl label-inline label-light-warning">Grade</span>
																	</span>
																</a>
															</li>
															<?php endif; ?>

															<li class="navi-item">
																<a href="/produtos/movimentacao/<?php echo e($p->id); ?>" class="navi-link">
																	<span class="navi-text">
																		<span class="label label-xl label-inline label-light-info">Movimentacao</span>
																	</span>
																</a>
															</li>

															<li class="navi-item">
																<a href="/produtos/etiqueta/<?php echo e($p->id); ?>" class="navi-link">
																	<span class="navi-text">
																		<span class="label label-xl label-inline label-light-dark">Etiqueta</span>
																	</span>
																</a>
															</li>

															<?php if($p->ecommerce): ?>

															<li class="navi-item">
																<a href="/produtoEcommerce/edit/<?php echo e($p->ecommerce->id); ?>" class="navi-link">
																	<span class="navi-text">
																		<span class="label label-xl label-inline label-light-dark">Ecommerce</span>
																	</span>
																</a>
															</li>
															<?php endif; ?>

														</ul>

													</div>
												</div>


											</div>

											<div class="card-body">

												<div class="kt-widget__info">
													<span class="kt-widget__label">Categoria:</span>
													<a target="_blank" href="/categorias/edit/<?php echo e($p->categoria->id); ?>" class="kt-widget__data text-success"><?php echo e($p->categoria->nome); ?></a>
												</div>
												<div class="kt-widget__info">
													<span class="kt-widget__label">Valor de venda:</span>
													<a class="kt-widget__data text-success"><?php echo e(number_format($p->valor_venda, $casasDecimais, ',', '.')); ?></a>
												</div>
												<div class="kt-widget__info">
													<span class="kt-widget__label">Valor de compra:</span>
													<a class="kt-widget__data text-success"><?php echo e(number_format($p->valor_compra, $casasDecimais, ',', '.')); ?></a>
												</div>
												<div class="kt-widget__info">
													<span class="kt-widget__label">% Lucro:</span>
													<a class="kt-widget__data text-success"><?php echo e($p->percentual_lucro); ?>%</a>
												</div>
												<div class="kt-widget__info">
													<span class="kt-widget__label">Unidade:</span>
													<a class="kt-widget__data text-success"><?php echo e($p->unidade_compra); ?>/<?php echo e($p->unidade_venda); ?></a>
												</div>
												<div class="kt-widget__info">
													<span class="kt-widget__label">Data de cadastro:</span>
													<a class="kt-widget__data text-success"><?php echo e(\Carbon\Carbon::parse($p->created_at)->format('d/m/Y H:i')); ?></a>
												</div>
												<div class="kt-widget__info">
													<span class="kt-widget__label">Gerenciar estoque:</span>
													<?php if($p->gerenciar_estoque): ?>
													<span class="label label-xl label-inline label-light-success">Sim</span>
													<?php else: ?>
													<span class="label label-xl label-inline label-light-warning">Não</span>
													<?php endif; ?>
												</div>
												<div class="kt-widget__info">
													<span class="kt-widget__label">Tipo grade:</span>
													<?php if($p->grade): ?>
													<span class="label label-xl label-inline label-light-success">Sim</span>
													<?php else: ?>
													<span class="label label-xl label-inline label-light-warning">Não</span>
													<?php endif; ?>

												</div>

												<div class="kt-widget__info">
													<span class="kt-widget__label">Estoque:</span>
													<a class="kt-widget__data text-success">

														<?php if($p->estoque): ?>
														<?php if($p->unidade_venda == 'UN' || $p->unidade_venda == 'UNID'): ?>
														<?php echo e(number_format($p->estoque_atual)); ?>

														<?php else: ?>
														<?php echo e($p->estoque_atual); ?>

														<?php endif; ?>

														<?php else: ?>
														0
														<?php endif; ?>
													</a>
												</div>

											</div>

										</div>
									</div>
								</div>

								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</div>
						</div>
					</div>
				</div>
			</div>

			<div class="d-flex justify-content-between align-items-center flex-wrap">
				<div class="d-flex flex-wrap py-2 mr-3">
					<?php if(isset($links)): ?>
					<?php echo e($produtos->links()); ?>

					<?php endif; ?>
				</div>
			</div>
		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('default.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcosbueno/Documents/laravel/metronic_multi_8.4/resources/views/produtos/list.blade.php ENDPATH**/ ?>