<!DOCTYPE html>
<html>
<head>
	<title></title>
	<link rel="stylesheet" href="https://unpkg.com/purecss@1.0.1/build/pure-min.css" integrity="sha384-oAOxQR6DkCoMliIh8yFnu25d7Eq/PHS21PClpwjOTeU2jRSq11vu66rf90/cZr47" crossorigin="anonymous">
	<style type="text/css">
		.soma{
			font-size: 30px;
		}

		.center{
			text-align: center;
			line-height: 0.5;
		}

		.text-success{
			color: #00e676;
		}

		.text-info{
			color: #8D56FC;
		}

		.bg-info{
			background: #8D56FC;
			color: #fff;
		}

		.bg-success{
			background: #00e676;
			color: #fff;
		}

		.text-danger{
			color: #e53935;
		}

		.bg-danger{
			background: #e53935;
			color: #fff;
		}

		tr{
			height: 70px;
		}
		th{
			font-size: 20px;
			height: 70px;
			margin-left: 10px;

		}
		td{
			font-size: 16px;
			height: 40px;
			margin-left: 5px;
		}

	</style>
</head>
<body>
	<div class="row">
		<div class="col s12">
			<h3 class="center-align">DRE <?php echo e(\Carbon\Carbon::parse($dre->inicio)->format('d/m/Y')); ?> - <?php echo e(\Carbon\Carbon::parse($dre->fim)->format('d/m/Y')); ?></h3>

			<?php if($tributacao->regime != 1): ?>

			<h2 class="card-title">% Imposto: 
				<strong class="text-primary"><?php echo e(number_format($dre->percentual_imposto, 2, ',', '.')); ?>

				</strong>
			</h2>

			<?php endif; ?>

			<h2 class="card-title">Observação: 
				<strong class="text-info">
					<?php echo e($dre->observacao != "" ? $dre->observacao : "--"); ?>

				</strong>
			</h2>
		</div>

		
		<table>
			<?php $__currentLoopData = $dre->categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

			<tbody>

				<tr class="bg-success">
					<th width="350"><?php echo e($c->nome); ?></th>
					<th width="180"></th>
				</tr>

				<?php $__currentLoopData = $c->lancamentos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $l): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

				<tr>
					<td width="350"><?php echo e($l->nome); ?></td>
					<td width="180">R$ <?php echo e(number_format($l->valor, 2, ',', '.')); ?></td>
				</tr>


				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

				<?php if($key > 2): ?>
				<tr class="text-info">
					<th width="350"><?php echo e($c->nome); ?></th>
					<th width="180">R$ <?php echo e(number_format($c->soma(), 2, ',', '.')); ?></th>
				</tr>
				<?php endif; ?>

			</tbody>

			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

			

			<tr class="<?php if($dre->lucro_prejuizo >= 0): ?> bg-success <?php else: ?> bg-danger <?php endif; ?>">
				<th width="350">Lucro (Prejuizo) no Período</th>
				<th width="180">R$ <?php echo e(number_format($dre->lucro_prejuizo, 2, ',', '.')); ?></th>
			</tr>

		</table>


	</div>
</body>
<?php /**PATH /Users/marcosbueno/Documents/laravel/metronic_multi_8.4/resources/views/dre/imprimir.blade.php ENDPATH**/ ?>