<?php $__env->startSection('content'); ?>
<style type="text/css">
	th{
		font-size: 12px;
	}
	td{
		font-size: 10px;
	}
</style>
<div class="row">
	<div class="col s12">
		<h3 class="center-align">Relatório de Vendas</h3>
		<?php if($data_inicial && $data_final): ?>
		<h4>Periodo: <?php echo e($data_inicial); ?> - <?php echo e($data_final); ?></h4>
		<?php endif; ?>
	</div>

	<table class="pure-table">
		<thead>
			<tr>
				<th width="70">DATA</th>
				<th width="70">ID</th>
				<th width="100">VENDEDOR</th>
				<th width="120">CLIENTE</th>
				<th width="80">FORMA DE PAGAMENTO</th>
				<th width="80">DESPESAS OPERACIONAIS</th>
				<th width="80">DESCONTO</th>
				<th width="80">VALOR VENDA LIQUIDA</th>
				<th width="80">VALOR TOTAL</th>
			</tr>
		</thead>
		<?php
		$somaPedido = 0;
		$somaPedidoLiquido = 0;
		$somaPdv = 0;
		$somaDesconto = 0;
		?>
		<tbody>
			<?php $__currentLoopData = $vendas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			<tr class="<?php if($key%2 == 0): ?> pure-table-odd <?php endif; ?>">
				<td><center><?php echo e(\Carbon\Carbon::parse($v->created_at)->format('d/m/Y H:i')); ?></center></td>
				<td><center><?php echo e($v->id); ?></center></td>
				<td><center><?php echo e($v->vendedor()); ?></center></td>
				<td><center><?php echo e($v->cliente ? $v->cliente->razao_social : 'Consumidor final'); ?></center></td>
				<?php if(isset($v->cpf)): ?>
				<td><center><?php echo e($v->getTipoPagamento2()); ?></center></td>
				<?php else: ?>
				<td><center><?php echo e($v->getTipoPagamento()); ?></center></td>
				<?php endif; ?>
				<?php if($v->tbl == 'pdv'): ?>
				<td><center>R$ 0,00</center></td>

				<td><center>R$ <?php echo e(number_format($v->desconto, 2, ',', '.')); ?></center></td>
				<td><center>R$ <?php echo e(number_format($v->valor_total, 2, ',', '.')); ?></center></td>
				<td><center>R$ <?php echo e(number_format($v->valor_total+$v->desconto, 2, ',', '.')); ?></center></td>
				<?php else: ?>
				<td><center>R$ <?php echo e($v->valorDespesaOperacionais()); ?></center></td>
				<td><center>R$ <?php echo e(number_format($v->desconto, 2, ',', '.')); ?></center></td>
				<td><center>R$ <?php echo e(number_format($v->valorLiquido(), 2, ',', '.')); ?></center></td>
				<td><center>R$ <?php echo e(number_format($v->valor_total, 2, ',', '.')); ?></center></td>
				<?php endif; ?>
				
			</tr>

			<?php
			if(!isset($v->cpf)){
			$somaPedido += $v->valor_total;
			$somaPedidoLiquido += $v->valorLiquido();
			}else{
			$somaPdv += $v->valor_total;
			}
			$somaDesconto += $v->desconto
			?>
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		</tbody>
	</table>

	<h4>Soma Pedido: <strong style="color: blue"><?php echo e(number_format($somaPedido, 2, ',', '.')); ?></strong></h4>
	<h4>Soma Pedido Liquido: <strong style="color: blue"><?php echo e(number_format($somaPedidoLiquido, 2, ',', '.')); ?></strong></h4>
	<h4>Soma PDV: <strong style="color: purple"><?php echo e(number_format($somaPdv, 2, ',', '.')); ?></strong></h4>

	<h3>Total: <strong style="color: green"><?php echo e(number_format($somaPedidoLiquido + $somaPdv, 2, ',', '.')); ?></strong></h3>
	<h3>Soma Desconto: <strong style="color: red"><?php echo e(number_format($somaDesconto, 2, ',', '.')); ?></strong></h3>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('relatorios.cabecalho', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcosbueno/Documents/laravel/metronic_multi_8.4/resources/views/relatorios/relatorio_venda2.blade.php ENDPATH**/ ?>