<?php $__env->startSection('content'); ?>

<style type="text/css">
	.checkout__input span{
		font-size: 16px;
	}
	.form-control{
		color: #000;
	}

	table{
		font-size: 15px;
	}

	.checkout__order__subtotal{
		font-size: 16px;
		margin-top: 10px;
	}

	.checkout__order__total{
		font-size: 18px;
	}

	.text-danger{
		font-size: 18px;
	}
</style>
<div class="cart_section">
	<div class="">
		<div class="row">
			<div class="col-lg-10 offset-lg-1">
				<div class="cart_container">
					<div class="cart_title">Realize seu cadastro :)
						<a class="btn btn-info" href="<?php echo e($rota); ?>/login">Já sou cadastrado</a>


						<form method="post">
							<?php echo csrf_field(); ?>

							<input type="hidden" value="<?php echo e($default['config']->empresa_id); ?>" name="empresa_id">
							<input type="hidden" value="<?php echo e($default['carrinho']->id); ?>" name="pedido_id">
							<br>
							<div class="row">

								<div class="col-lg-8 col-md-12">
									<div class="row">
										<div class="col-lg-6">
											<div class="checkout__input">
												<span>Nome *</span>

												<input  class="form-control" autofocus name="nome" value="<?php echo e(old('nome')); ?>" type="text">
												<?php if($errors->has('nome')): ?>
												<label class="text-danger"><?php echo e($errors->first('nome')); ?></label>
												<?php endif; ?>
											</div>
										</div>
										<div class="col-lg-6">
											<div class="checkout__input">
												<span>Sobre nome *</span>
												<input class="form-control" value="<?php echo e(old('sobre_nome')); ?>" name="sobre_nome" type="text">
												<?php if($errors->has('sobre_nome')): ?>
												<label class="text-danger"><?php echo e($errors->first('sobre_nome')); ?></label>
												<?php endif; ?>
											</div>
										</div>
									</div>

									<div class="row">
										<div class="col-lg-6">
											<div class="checkout__input">

												<span>Telefone *</span>

												<input class="form-control" data-mask="(00) 00000-0000" value="<?php echo e(old('telefone')); ?>" name="telefone" type="text">
												<?php if($errors->has('telefone')): ?>
												<label class="text-danger"><?php echo e($errors->first('telefone')); ?></label>
												<?php endif; ?>
											</div>
										</div>
										<div class="col-lg-6">
											<div class="checkout__input">

												<span>Email *</span>
												<input class="form-control" value="<?php echo e(old('email')); ?>" name="email" type="text">
												<?php if($errors->has('email')): ?>
												<label class="text-danger"><?php echo e($errors->first('email')); ?></label>
												<?php endif; ?>
											</div>
										</div>
									</div>

									<div class="row">
										<div class="col-lg-4">
											<div class="checkout__input">

												<span>Senha *</span>

												<input class="form-control" name="senha" type="password">
												<?php if($errors->has('senha')): ?>
												<label class="text-danger"><?php echo e($errors->first('senha')); ?></label>
												<?php endif; ?>
											</div>
										</div>

										<div class="col-lg-2">
											<div class="checkout__input">

												<span>Tipo Doc. *</span>

												<select name="tp_doc" id="tp_doc" class="form-control" style="height: 38px;">
													<option <?php if(old('tp_doc') == 'cpf'): ?> selected <?php endif; ?> value="cpf">CPF</option>
													<option <?php if(old('tp_doc') == 'cnpj'): ?> selected <?php endif; ?> value="cnpj">CNPJ</option>
												</select>

											</div>
										</div>
										<div class="col-lg-5">
											<div class="checkout__input">
												<span class="lbl_doc">CPF *</span>

												<input class="form-control" id="doc" value="<?php echo e(old('cpf')); ?>" data-mask="000.000.000-00" data-mask-reverse="true" name="cpf" type="text">
												<?php if($errors->has('cpf')): ?>
												<label class="text-danger"><?php echo e($errors->first('cpf')); ?></label>
												<?php endif; ?>
											</div>
										</div>

										<div class="col-lg-5 ie" style="display: none;">
											<div class="checkout__input">
												<span class="">IE *</span>

												<input class="form-control" id="doc" value="<?php echo e(old('ie')); ?>" name="ie" type="text">
												<?php if($errors->has('ie')): ?>
												<label class="text-danger"><?php echo e($errors->first('ie')); ?></label>
												<?php endif; ?>
											</div>
										</div>


									</div>

									<div class="row">
										<div class="col-lg-9">
											<div class="checkout__input">

												<span>Rua *</span>

												<input class="form-control" value="<?php echo e($enderecoCep != null ? $enderecoCep->logradouro : old('rua')); ?>" name="rua" type="text">
												<?php if($errors->has('rua')): ?>
												<label class="text-danger"><?php echo e($errors->first('rua')); ?></label>
												<?php endif; ?>
											</div>
										</div>
										<div class="col-lg-3">
											<div class="checkout__input">

												<span>Nº *</span>

												<input class="form-control" value="<?php echo e(old('numero')); ?>" name="numero" type="text">
												<?php if($errors->has('numero')): ?>
												<label class="text-danger"><?php echo e($errors->first('numero')); ?></label>
												<?php endif; ?>
											</div>
										</div>
									</div>

									<div class="row">
										<div class="col-lg-6">
											<div class="checkout__input">

												<span>Bairro *</span>

												<input class="form-control" value="<?php echo e($enderecoCep != null ? $enderecoCep->bairro : old('bairro')); ?>" name="bairro" type="text">
												<?php if($errors->has('bairro')): ?>
												<label class="text-danger"><?php echo e($errors->first('bairro')); ?></label>
												<?php endif; ?>
											</div>
										</div>
										<div class="col-lg-6">
											<div class="checkout__input">

												<span>Cidade *</span>

												<input class="form-control" value="<?php echo e($enderecoCep != null ? $enderecoCep->localidade : old('cidade')); ?>" name="cidade" type="text">
												<?php if($errors->has('cidade')): ?>
												<label class="text-danger"><?php echo e($errors->first('cidade')); ?></label>
												<?php endif; ?>
											</div>
										</div>
									</div>

									<div class="row">
										<div class="col-lg-2">
											<div class="checkout__input">

												<span>UF *</span>

												<input class="form-control" data-mask="AA" data-mask-reverse="true" value="<?php echo e($enderecoCep != null ? $enderecoCep->uf : old('uf')); ?>" name="uf" type="text">
												<?php if($errors->has('uf')): ?>
												<label class="text-danger"><?php echo e($errors->first('uf')); ?></label>
												<?php endif; ?>
											</div>
										</div>
										<div class="col-lg-4">
											<div class="checkout__input">
												<span>CEP *</span>

												<input class="form-control" data-mask="00000-000" data-mask-reverse="true" value="<?php echo e($default['carrinho']->observacao != '' ? $default['carrinho']->observacao : old('cep')); ?>" name="cep" type="text">
												<?php if($errors->has('cep')): ?>
												<label class="text-danger"><?php echo e($errors->first('cep')); ?></label>
												<?php endif; ?>
											</div>
										</div>

										<div class="col-lg-4">
											<div class="checkout__input">

												<span>Complemento </span>

												<input class="form-control" value="<?php echo e(old('complemento')); ?>" name="complemento" type="text">
												<?php if($errors->has('complemento')): ?>
												<label class="text-danger"><?php echo e($errors->first('complemento')); ?></label>
												<?php endif; ?>
											</div>
										</div>
									</div>

									<div class="checkout__input">

										<span>Observação </span>

										<input class="form-control" value="<?php echo e(old('observacao')); ?>" name="observacao" type="text"
										placeholder="Observação sobre entrega por exemplo">
									</div>


								</div>

								<div class="col-lg-4 col-md-6">
									<div class="cart_container">
										<div class="cart_items" style="margin-top: 40px;">

											<ul class="cart_list">

												<li class="cart_item clearfix">
													<div class="cart_title">Seu Pedido</div>

													<table>
														<thead>
															<tr>
																<th style="width: 77%;">Produto</th>
																<th>Total</th>
															</tr>
														</thead>

														<tbody>
															<?php if($default['carrinho'] != null): ?>
															<?php $__currentLoopData = $default['carrinho']->itens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
															<tr>
																<td><?php echo e($i->produto->produto->nome); ?>

																</td>
																<td>
																	R$ <?php echo e(number_format($i->produto->valor, 2, ',', '.')); ?>

																</td>
															</tr>
															<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
															<?php endif; ?>
														</tbody>
													</table>
													<hr>
													<div class="checkout__order__subtotal">Frete <span>R$ <?php echo e(number_format($default['carrinho']->valor_frete, 2, ',', '.')); ?></span></div>
													<div class="checkout__order__total">Total <span>R$ <?php echo e($default['carrinho'] != null ? number_format($default['carrinho']->somaItens() + $default['carrinho']->valor_frete, 2, ',', '.') : '0,00'); ?></span></div>
												</li>
											</ul>
										</div>
									</div>
								</div>

							</div>

							<button type="submit" class="button contact_submit_button">SALVAR</button>
						</form>
					</div>

				</div>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
<script type="text/javascript">
	$(function(){
		changeDoc()
	})
	$('#tp_doc').change((target) => {
		changeDoc()
	})

	function changeDoc(){
		let v = $('#tp_doc').val()

		if(v == 'cpf'){
			$('#doc').mask('000.000.000-00', {reverse: true});
			$('.lbl_doc').html('CPF *');
			$('.ie').css('display', 'none');

		}else{
			$('#doc').mask('00.000.000/0000-00', {reverse: true});
			$('.lbl_doc').html('CNPJ *');
			$('.ie').css('display', 'block');
		}
	}
</script>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('ecommerce_one_tech.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcosbueno/Documents/laravel/metronic_multi_8.4/resources/views/ecommerce_one_tech/checkout.blade.php ENDPATH**/ ?>