<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col s12">
		<h3 class="center-align">Relatório Custo/Venda</h3>
		<?php if($data_inicial && $data_final): ?>
		<h4>Periodo: <?php echo e($data_inicial); ?> - <?php echo e($data_final); ?></h4>
		<?php endif; ?>
	</div>

	<table class="pure-table">
		<thead>
			<tr>
				<th width="50">CÓD</th>
				<th width="200">DESCRIÇÃO</th>
				<th width="80">VL CUSTO</th>
				<th width="80">VL VENDA</th>
				<th width="80">QTD</th>
				<th width="80">TOTAL CUSTO/VENDA</th>
			</tr>
		</thead>

		<?php
		$somaCusto = 0;
		$somaVenda = 0;
		$somaItens = 0;
		?>
		<tbody>
			<?php $__currentLoopData = $itens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			<tr class="<?php if($key%2 == 0): ?> pure-table-odd <?php endif; ?>">
				<td><center><?php echo e($i['id']); ?></center></td>
				<td>
					<center><?php echo e($i['nome']); ?> 
						<?php if($i['grade']): ?>
						<?php echo e($i['str_grade']); ?>

						<?php endif; ?>
					</center>
				</td>
				<td><center><?php echo e(number_format($i['valor_compra'], 2, ',', '.')); ?></center></td>
				<td><center><?php echo e(number_format($i['valor_venda'], 2, ',', '.')); ?></center></td>

				<?php if($i['unidade'] == 'UN'): ?>
				<td><center><?php echo e(number_format($i['total'])); ?> <?php echo e($i['unidade']); ?></center></td>
				<?php else: ?>
				<td><center><?php echo e(number_format($i['total'], 2)); ?> <?php echo e($i['unidade']); ?></center></td>

				<?php endif; ?>
				
				<td>
					<center>
						<?php echo e(number_format($i['valor_compra']*$i['total'], 2, ',', '.')); ?>/<?php echo e(number_format($i['valor_venda']*$i['total'], 2, ',', '.')); ?>

					</center>
				</td>

			</tr>

			<?php
			$somaCusto += $i['valor_compra']*$i['total'];
			$somaVenda += $i['valor_venda']*$i['total'];
			$somaItens += $i['total'];
			?>

			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		</tbody>
	</table>

	<h4>Soma Custo: <strong style="color: red"><?php echo e(number_format($somaCusto, 2, ',', '.')); ?></strong></h4>
	<h4>Soma Venda: <strong style="color: green"><?php echo e(number_format($somaVenda, 2, ',', '.')); ?></strong></h4>
	<h4>Soma Itens: <strong style="color: purple"><?php echo e($somaItens); ?></strong></h4>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('relatorios.cabecalho', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcosbueno/Documents/laravel/metronic_multi_8.4/resources/views/relatorios/relatorio_venda_produtos.blade.php ENDPATH**/ ?>