<?php $__env->startSection('content'); ?>

<div class="card card-custom gutter-b">
	<div class="card-body">
		<div class="<?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInLeft">
			<div class="col-12">
				<div class="row">

					<a href="/contasReceber/new" class="btn btn-lg btn-success">
						<i class="fa fa-plus"></i>Novo Conta a Receber
					</a>
					<?php if(isset($paraImprimir)): ?>
					<form method="post" action="/contasReceber/relatorio">
						<?php echo csrf_field(); ?>
						<input type="hidden" name="cliente" value="<?php echo e(isset($cliente) ? $cliente : ''); ?>">
						<input type="hidden" name="tipo_filtro_data" value="<?php echo e(isset($tipo_filtro_data) ? $tipo_filtro_data : ''); ?>">
						<input type="hidden" name="data_inicial" value="<?php echo e(isset($dataInicial) ? $dataInicial : ''); ?>">
						<input type="hidden" name="data_final" value="<?php echo e(isset($dataFinal) ? $dataFinal : ''); ?>">
						<input type="hidden" name="tipo_pesquisa" value="<?php echo e(isset($tipo_pesquisa) ? $tipo_pesquisa : ''); ?>">
						<input type="hidden" name="status" value="<?php echo e(isset($status) ? $status : ''); ?>">
						<input type="hidden" name="categoria" value="<?php echo e(isset($categoria) ? $categoria : ''); ?>">
						<button style="margin-left: 5px;" href="/contasPagar/new" class="btn btn-lg btn-info">
							<i class="fa fa-print"></i>Imprimir relatório
						</button>
					</form>
					<?php endif; ?>

				</div>
			</div>
		</div>
		<br>

		<div class="<?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInRight" id="kt_user_profile_aside" style="margin-left: 10px; margin-right: 10px;">

			<form method="get" action="/contasReceber/filtro">
				<div class="row align-items-center">

					
					<div class="form-group col-lg-2 col-md-4 col-sm-6">
						<label class="col-form-label">Tipo de pesquisa</label>

						<select name="tipo_pesquisa" class="custom-select">
							<?php $__currentLoopData = App\Models\Cliente::tiposPesquisa(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<option <?php if(isset($tipoPesquisa)): ?> <?php if($tipoPesquisa == $key): ?> selected <?php endif; ?> <?php endif; ?> value="<?php echo e($key); ?>"><?php echo e($t); ?></option>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</select>
					</div>
					<div class="form-group col-lg-4 col-xl-4">
						<div class="row align-items-center">

							<div class="col-md-12 my-2 my-md-0">
								<label class="col-form-label">Cliente</label>

								<div class="input-icon">
									<input type="text" name="cliente" value="<?php echo e(isset($cliente) ? $cliente : ''); ?>" class="form-control" placeholder="Cliente" id="kt_datatable_search_query">
									<span>
										<i class="fa fa-search"></i>
									</span>
								</div>
							</div>
						</div>
					</div>

					<div class="form-group col-lg-2 col-md-4 col-sm-6">
						<label class="col-form-label">Filtro de data</label>

						<select class="custom-select form-control" id="tipo_filtro_data" name="tipo_filtro_data">
							<option <?php if(isset($tipo_filtro_data) && $tipo_filtro_data == 1): ?> selected <?php endif; ?> value="1">Vencimento</option>
							<option <?php if(isset($tipo_filtro_data) && $tipo_filtro_data == 2): ?> selected <?php endif; ?> value="2">Data de registro</option>
						</select>
					</div>

					<div class="form-group col-lg-2 col-md-4 col-sm-6">
						<label class="col-form-label">Data inicial</label>
						<div class="">
							<div class="input-group date">
								<input type="text" name="data_inicial" class="form-control" readonly value="<?php echo e(isset($dataInicial) ? $dataInicial : ''); ?>" id="kt_datepicker_3" />
								<div class="input-group-append">
									<span class="input-group-text">
										<i class="la la-calendar"></i>
									</span>
								</div>
							</div>
						</div>
					</div>

					<div class="form-group col-lg-2 col-md-4 col-sm-6">
						<label class="col-form-label">Data final</label>
						<div class="">
							<div class="input-group date">
								<input type="text" name="data_final" class="form-control" readonly value="<?php echo e(isset($dataFinal) ? $dataFinal : ''); ?>" id="kt_datepicker_3" />
								<div class="input-group-append">
									<span class="input-group-text">
										<i class="la la-calendar"></i>
									</span>
								</div>
							</div>
						</div>
					</div>

					<div class="form-group col-lg-2 col-md-4 col-sm-6">
						<label class="col-form-label">Estado</label>

						<select class="custom-select form-control" id="status" name="status">
							<option <?php if(isset($status) && $status == 'todos'): ?> selected <?php endif; ?> value="todos">TODOS</option>
							<option <?php if(isset($status) && $status == 'pago'): ?> selected <?php endif; ?> value="pago">PAGO</option>
							<option <?php if(isset($status) && $status == 'pendente'): ?> selected <?php endif; ?> value="pendente">PENDENTE</option>
						</select>
					</div>

					<div class="form-group col-lg-2 col-md-4 col-sm-6">
						<label class="col-form-label">Categoria</label>

						<select class="custom-select form-control" id="categoria" name="categoria">
							<option <?php if(isset($categoria) && $categoria == 'todos'): ?> selected <?php endif; ?> value="todos">TODOS</option>
							<?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<option <?php if(isset($categoria) && $categoria == $c->id): ?> selected <?php endif; ?> value="<?php echo e($c->id); ?>"><?php echo e($c->nome); ?></option>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</select>
					</div>

					<div class="col-lg-2 col-xl-2 mt-2 mt-lg-0">
						<button style="margin-top: 10px;" class="btn btn-light-primary px-6 font-weight-bold">Pesquisa</button>
					</div>
				</div>

			</form>
			<br>
			<h4>Lista de Contas a Receber</h4>
			<h6 style="color: red">*<?php echo e($infoDados); ?></h6>
			<label>Total de registros: <?php echo e(sizeof($contas)); ?></label>

			<div class="row">
				<div class="col-12">
					<button id="btn_seleciona_varios" class="btn btn-light">
						<i class="la la-list"></i>
						Selecionar varios
					</button>

					<button style="display: none" id="btn_gerar" class="btn btn-success">
						<i class="la la-list"></i>
						Gerar Boletos
					</button>

					<a href="/remessasBoleto" class="btn btn-danger">
						<i class="la la-list"></i>
						Remessas de boleto
					</a>

					<br><br>
				</div>
			</div>

			<div class="row">

				<?php 
				$somaValor = 0;
				$somaRecebido = 0;
				$somaPendente = 0;
				?>

				<div class="col-sm-12 col-lg-12 col-md-12 col-xl-12">

					<div class="wizard wizard-3" id="kt_wizard_v3" data-wizard-state="between" data-wizard-clickable="true">
						<div class="wizard-nav">

							<div class="wizard-steps px-8 py-8 px-lg-15 py-lg-3">
								<!--begin::Wizard Step 1 Nav-->
								<div class="wizard-step" data-wizard-type="step" data-wizard-state="done">
									<div class="wizard-label">
										<h3 class="wizard-title">
											<span>
												<i style="font-size: 40px" class="la la-table"></i>
												Tabela
											</span>
										</h3>
										<div class="wizard-bar"></div>
									</div>
								</div>
								<!--end::Wizard Step 1 Nav-->
								<!--begin::Wizard Step 2 Nav-->
								<div class="wizard-step" data-wizard-type="step" data-wizard-state="current">
									<div class="wizard-label" id="grade">
										<h3 class="wizard-title">
											<span>
												<i style="font-size: 40px" class="la la-tablet"></i>
												Grade
											</span>
										</h3>
										<div class="wizard-bar"></div>
									</div>
								</div>

							</div>
						</div>

						<div class="pb-5" data-wizard-type="step-content">
							<div class="row">
								<div class="col-xl-12">

									<div id="kt_datatable" class="datatable datatable-bordered datatable-head-custom datatable-default datatable-primary datatable-loaded">

										<table class="datatable-table" style="max-width: 100%; overflow: scroll">
											<thead class="datatable-head">
												<tr class="datatable-row" style="left: 0px;">
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 250px;">CLIENTE</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 150px;">CATEGORIA</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 120px;">VALOR INTEGRAL</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 120px;">VALOR RECEBIDO</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 120px;">DATA DE REGISTRO</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 120px;">DATA DE RECEBIMENTO</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 120px;">DATA VENCIMENTO</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 120px;">ESTADO</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 300px;">AÇÕES</span></th>
												</tr>
											</thead>
											<tbody id="body" class="datatable-body">
												<?php $__currentLoopData = $contas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<tr class="datatable-row">
													<td class="datatable-cell">
														<span class="codigo" style="width: 250px;" id="id">
															<?php if($c->venda_id != null || $c->venda_caixa_id != null): ?>
															<?php if($c->venda_id != null): ?>
															<?php echo e($c->venda->cliente->razao_social); ?>

															<?php else: ?>
															<?php echo e($c->vendaCaixa->cliente->razao_social); ?>

															<?php endif; ?>
															<?php else: ?>
															<?php if($c->cliente_id != null): ?>
															<?php echo e($c->cliente->razao_social); ?>

															<?php else: ?>
															--
															<?php endif; ?>
															<?php endif; ?>

														</span>
													</td>
													<td class="datatable-cell"><span class="codigo" style="width: 150px;" id="id"><?php echo e($c->categoria->nome); ?></span>
													</td>

													<td class="datatable-cell">
														<span class="codigo" style="width: 120px;" id="id">
															R$ <?php echo e(number_format($c->valor_integral, $casasDecimais, ',', '.')); ?>

														</span>
													</td>

													<td class="datatable-cell">
														<span class="codigo" style="width: 120px;" id="id">
															R$ <?php echo e(number_format($c->valor_recebido, $casasDecimais, ',', '.')); ?>

														</span>
													</td>
													<td class="datatable-cell">
														<span class="codigo" style="width: 120px;" id="id">
															<?php echo e(\Carbon\Carbon::parse($c->created_at)->format('d/m/Y H:i:s')); ?>

														</span>
													</td>
													<td class="datatable-cell">
														<span class="codigo" style="width: 120px;" id="id">
															<?php if($c->status): ?>
															<?php echo e(\Carbon\Carbon::parse($c->data_recebimento)->format('d/m/Y')); ?>

															<?php else: ?>
															--
															<?php endif; ?>
														</span>
													</td>

													<td class="datatable-cell">
														<span class="codigo" style="width: 120px;" id="id">
															<?php echo e(\Carbon\Carbon::parse($c->data_vencimento)->format('d/m/Y')); ?>

														</span>
													</td>

													<td class="datatable-cell">
														<span class="codigo" style="width: 120px;" id="id">
															<?php if($c->status == true): ?>
															<span class="label label-xl label-inline label-light-success">Recebido</span>
															<?php else: ?>
															<span class="label label-xl label-inline label-light-danger">Pendente</span>
															<?php endif; ?>
														</span>
													</td>

													<td class="datatable-cell">
														<span class="codigo" style="width: 300px;" id="id">

															<?php if(!$c->boleto): ?>


															<a href="/contasReceber/edit/<?php echo e($c->id); ?>" class="btn btn-warning">
																<i class="la la-edit"></i>
															</a>
															<a onclick='swal("Atenção!", "Deseja remover este registro?", "warning").then((sim) => {if(sim){ location.href="/contasReceber/delete/<?php echo e($c->id); ?>" }else{return false} })' href="#!" class="btn btn-danger">
																<i class="la la-trash"></i>
															</a>

															<?php endif; ?>

															<?php if($c->status == false): ?>

															<a href="/contasReceber/receber/<?php echo e($c->id); ?>" class="btn btn-success">
																<i class="la la-money"></i>
															</a>

															<?php endif; ?>

															<?php if(!$c->boleto): ?>

															<a href="/boleto/gerar/<?php echo e($c->id); ?>" class="btn btn-info">
																<i class="la la-file"></i>
															</a>

															<?php else: ?>

															<a target="_blank" href="/boleto/imprimir/<?php echo e($c->boleto->id); ?>" class="btn btn-primary">
																<i class="la la-print"></i>
															</a>


															<a target="_blank" href="/boleto/gerarRemessa/<?php echo e($c->boleto->id); ?>" class="btn btn-info">
																<i class="la-file-alt"></i>
															</a>

															<?php endif; ?>

															<?php if($c->venda_id != null || $c->venda_caixa_id != null): ?>
															<a href="/contasReceber/detalhes_venda/<?php echo e($c->id); ?>" class="btn btn-warning" title="Detalhes da venda">
																<i class="la la-list"></i>
															</a>
															<?php endif; ?>
															
														</span>
													</td>
												</tr>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
											</tbody>
										</table>
									</div>
								</div>
							</div>
						</div>

						<input type="hidden" id="contas" value="<?php echo e(json_encode($contas)); ?>" name="">
						<div class="pb-5" data-wizard-type="step-content">
							<div class="row">
								<?php $__currentLoopData = $contas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

								<div class="col-sm-12 col-lg-6 col-md-6 col-xl-4">
									<div class="card card-custom gutter-b example example-compact">
										<div class="card-header">
											<div class="card-title">

												<?php if(!$c->boleto): ?>
												<label style="display: none" class="checkbox checkbox-success" for="sel_<?php echo e($c->id); ?>">
													<input id="sel_<?php echo e($c->id); ?>" class="select" type="checkbox" name="Checkboxes5"/>
													<span></span>
												</label>
												<?php endif; ?>
												<h3 style="width: 230px; font-size: 20px; height: 10px;" class="card-title">
													R$ <strong id="valor_<?php echo e($c->id); ?>"><?php echo e(number_format($c->valor_integral, $casasDecimais, ',', '.')); ?></strong>
												</h3>

											</div>

											<div class="card-toolbar">
												<div class="dropdown dropdown-inline" data-toggle="tooltip" title="" data-placement="left" data-original-title="Ações">
													<a href="#" class="btn btn-hover-light-primary btn-sm btn-icon btn-action" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
														<i class="fa fa-ellipsis-h"></i>
													</a>
													<div class="dropdown-menu p-0 m-0 dropdown-menu-md dropdown-menu-left">
														<!--begin::Navigation-->
														<ul class="navi navi-hover">
															<li class="navi-header font-weight-bold py-4">
																<span class="font-size-lg">Ações:</span>
															</li>


															<li class="navi-separator mb-3 opacity-70"></li>

															<?php if(!$c->boleto): ?>

															<li class="navi-item">
																<a href="/contasReceber/edit/<?php echo e($c->id); ?>" class="navi-link">
																	<span class="navi-text">
																		<span class="label label-xl label-inline label-light-primary">Editar</span>
																	</span>
																</a>
															</li>
															<li class="navi-item">
																<a onclick='swal("Atenção!", "Deseja remover este registro?", "warning").then((sim) => {if(sim){ location.href="/contasReceber/delete/<?php echo e($c->id); ?>" }else{return false} })' href="#!" class="navi-link">
																	<span class="navi-text">
																		<span class="label label-xl label-inline label-light-danger">Excluir</span>
																	</span>
																</a>
															</li>
															<?php endif; ?>

															<?php if($c->status == false): ?>

															<li class="navi-item">
																<a href="/contasReceber/receber/<?php echo e($c->id); ?>" class="navi-link">
																	<span class="navi-text">
																		<span class="label label-xl label-inline label-light-success">Receber</span>
																	</span>
																</a>
															</li>

															<?php endif; ?>

															<?php if(!$c->boleto): ?>
															<li class="navi-item">
																<a href="/boleto/gerar/<?php echo e($c->id); ?>" class="navi-link">
																	<span class="navi-text">
																		<span class="label label-xl label-inline label-light-info">Gerar Boleto</span>
																	</span>
																</a>
															</li>

															<?php else: ?>

															<li class="navi-item">
																<a target="_blank" href="/boleto/imprimir/<?php echo e($c->boleto->id); ?>" class="navi-link">
																	<span class="navi-text">
																		<span class="label label-xl label-inline label-light-info">Imprimir</span>
																	</span>
																</a>
															</li>

															<li class="navi-item">
																<a target="_blank" href="/boleto/gerarRemessa/<?php echo e($c->boleto->id); ?>" class="navi-link">
																	<span class="navi-text">
																		<span class="label label-xl label-inline label-light-warning">Gerar remessa</span>
																	</span>
																</a>
															</li>

															<?php endif; ?>

															<?php if($c->venda_id != null || $c->venda_caixa_id != null): ?>
															<li class="navi-item">
																<a href="/contasReceber/detalhes_venda/<?php echo e($c->id); ?>" class="navi-link">
																	<span class="navi-text">
																		<span class="label label-xl label-inline label-light-warning">Detalhes da Venda</span>
																	</span>
																</a>
															</li>
															<?php endif; ?>


														</ul>
														<!--end::Navigation-->
													</div>
												</div>

											</div>

											<div class="card-body">

												<div class="kt-widget__info">
													<span class="kt-widget__label">Cliente:</span>
													<a target="_blank" class="kt-widget__data text-success">
														<?php if($c->venda_id != null || $c->venda_caixa_id != null): ?>
														<?php if($c->venda_id != null): ?>
														<th><?php echo e($c->venda->cliente->razao_social); ?></th>
														<?php else: ?>
														<th><?php echo e($c->vendaCaixa->cliente->razao_social); ?></th>
														<?php endif; ?>
														<?php else: ?>
														<?php if($c->cliente_id != null): ?>
														<th><?php echo e($c->cliente->razao_social); ?></th>
														<?php else: ?>
														<th> -- </th>
														<?php endif; ?>
														<?php endif; ?>
													</a>
												</div>
												<div class="kt-widget__info">
													<span class="kt-widget__label">Categoria:</span>
													<a class="kt-widget__data text-success">
														<?php echo e($c->categoria->nome); ?> 
													</a>
												</div>
												<div class="kt-widget__info">
													<span class="kt-widget__label">Valor recebido:</span>
													<a class="kt-widget__data text-success">
														<?php echo e(number_format($c->valor_recebido, $casasDecimais, ',', '.')); ?>

													</a>
												</div>
												<div class="kt-widget__info">
													<span class="kt-widget__label">Data de registro:</span>
													<a class="kt-widget__data text-success">
														<?php echo e(\Carbon\Carbon::parse($c->created_at)->format('d/m/Y H:i:s')); ?>

													</a>
												</div>
												<div class="kt-widget__info">
													<span class="kt-widget__label">Data de recebimento:</span>
													<a class="kt-widget__data text-success">
														<?php if($c->status): ?>
														<?php echo e(\Carbon\Carbon::parse($c->data_recebimento)->format('d/m/Y')); ?>

														<?php else: ?>
														--
														<?php endif; ?>
													</a>
												</div>
												<div class="kt-widget__info">
													<span class="kt-widget__label">Data de vencimento:</span>
													<a class="kt-widget__data text-success">
														<?php echo e(\Carbon\Carbon::parse($c->data_vencimento)->format('d/m/Y')); ?>

													</a>
												</div>

												<div class="kt-widget__info">
													<span class="kt-widget__label">Estado:</span>
													<?php if($c->status == true): ?>
													<span class="label label-xl label-inline label-light-success">Recebido</span>
													<?php else: ?>
													<span class="label label-xl label-inline label-light-danger">Pendente</span>
													<?php endif; ?>
												</div>

												<?php if($c->boleto): ?>
												<div class="kt-widget__info" style="margin-top: 3px;">
													<span class="kt-widget__label">Boleto:</span>

													<span class="label label-xl label-inline label-light-success"><?php echo e($c->boleto->banco->banco); ?></span>

												</div>
												<?php else: ?>
												<div class="kt-widget__info" style="margin-top: 3px;">
													<span class="kt-widget__label">Boleto:</span>
													<span class="label label-xl label-inline label-light-info">--</span>

												</div>
												<?php endif; ?>


											</div>

										</div>

									</div>

								</div>

								<?php
								$somaValor += $c->valor_integral;
								$somaRecebido += $c->valor_recebido;

								if($c->status == false)
									$somaPendente += $c->valor_integral;
								?>

								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

							</div>
						</div>
					</div>
				</div>


				<div class="d-flex justify-content-between align-items-center flex-wrap">
					<div class="d-flex flex-wrap py-2 mr-3">
						<?php if(isset($links)): ?>
						<?php echo e($contas->links()); ?>

						<?php endif; ?>
					</div>
				</div>

				<div class="card-body">
					<div class="row">
						<div class="col-sm-12 col-lg-12 col-md-12 col-xl-12">
							<div class="card card-custom gutter-b example example-compact">
								<div class="card-header">

									<div class="card-body">
										<div class="row">
											<div class="col-6">

												<h3 class="card-title">Valor a Receber: <strong style="margin-left: 5px;"> R$ <?php echo e(number_format($somaPendente, 2, ',', '.')); ?></strong></h3>
											</div>
											<div style="display: none" class="col-6 div-valor-selecionado">

												<h3 class="card-title">Valor Selecionado: <strong style="margin-left: 5px;" id="valor-selecionado">R$ 0,00</strong></h3>
											</div>
										</div>
									</div>

								</div>
							</div>
						</div>

					</div>
				</div>
			</div>
		</div>
	</div>

	<?php $__env->startSection('javascript'); ?>
	<script type="text/javascript">
		var CONTAS = [];
		var ADICIONADAS = [];
		var SOMA = 0;
		var BTNSELECIONA = false;
		$(function () {
			CONTAS = JSON.parse($('#contas').val());
		});
		$('.select').click(() => {
			ADICIONADAS = []
			CONTAS.map((c) => {
				let s = $('#sel_'+c.id).is(':checked');
				if(s){
					ADICIONADAS.push(c)
				}
			})
			somaArray();
			verificaBotaoGerar();
		})

		function somaArray(){
			SOMA = 0;
			ADICIONADAS.map((a) => {
				SOMA += parseFloat(a.valor_integral.replace(',', '.'))
			})
			console.log(SOMA)
			$('#valor-selecionado').html(formatReal(SOMA))
		}

		$('#btn_seleciona_varios').click(() => {
			BTNSELECIONA = !BTNSELECIONA

			$('#grade').trigger('click')

			if(BTNSELECIONA){
				$('#btn_seleciona_varios').removeClass('btn-light')
				$('#btn_seleciona_varios').addClass('btn-info')
				$('.checkbox').css('display', 'block')
				$('.checkbox').css('margin-right', '5px')
				$('.btn-action').css('display', 'none')
				$('.div-valor-selecionado').css('display', 'block')
			}else{
				$('#btn_seleciona_varios').removeClass('btn-info')
				$('#btn_seleciona_varios').addClass('btn-light')

				$('.checkbox').css('display', 'none')
				$('.div-valor-selecionado').css('display', 'none')
				$('.btn-action').css('display', 'block')
			}

			ADICIONADAS.map((a) => {
				$('#sel_'+a.id).prop('checked', false)
			})
		})	

		function verificaBotaoGerar(){
			if(ADICIONADAS.length > 1){
				$('#btn_gerar').css('display', 'inline-block')
			}else{
				$('#btn_gerar').css('display', 'none')
			}
		}

		$('#btn_gerar').click(() => {
			let temp = [];
			ADICIONADAS.map((a) => {
				temp.push(a.id)
			})
			console.log(temp)
			location.href = path + 'boleto/gerarMultiplos/'+temp
		})

		function formatReal(v){
			return v.toLocaleString('pt-br',{style: 'currency', currency: 'BRL'});
		}

	</script>
	<?php $__env->stopSection(); ?>

	<?php $__env->stopSection(); ?>

<?php echo $__env->make('default.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcos/Documents/laravel/metronic_multi_8.4/resources/views/contaReceber/list.blade.php ENDPATH**/ ?>