<?php $__env->startSection('content'); ?>

<div class="row">
	<div class="col s12">
		<h3 >Relátorio de Contas a receber</h3>
		<?php if($data_inicial && $data_final): ?>
		<h4>Periodo: <?php echo e($data_inicial); ?> - <?php echo e($data_final); ?></h4>
		<?php endif; ?>
	</div>

	<table class="pure-table">
		<thead>
			<tr>

				<th width="110">VALOR</th>
				<th width="110">CLIENTE/REFERÊNCIA</th>
				<th width="100">DATA DE CADASTRO</th>
				<th width="100">DATA DE VENCIMENTO</th>
				<th width="100">ESTADO</th>
			</tr>
		</thead>

		<tbody>
			<?php $somaContas = 0; ?>
			<?php $__currentLoopData = $contas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			<tr class="<?php if($key%2 == 0): ?> pure-table-odd <?php endif; ?>">

				<td><?php echo e(number_format($c->valor_integral, 2, ',', '.')); ?></td>
				<td><?php echo e($c->cliente ? $c->cliente->razao_social : $c->referencia); ?></td>
				<td><?php echo e(\Carbon\Carbon::parse($c->created_at)->format('d/m/Y')); ?></td>
				<td><?php echo e(\Carbon\Carbon::parse($c->data_vencimento)->format('d/m/Y')); ?></td>
				<td>
					<?php if($c->status): ?>
					<span class="text-success">Pago</span>
					<?php else: ?>
					<span class="text-danger">Pendente</span>
					<?php endif; ?>
				</td>


			</tr>

			<?php $somaContas += $c->valor_integral; ?>
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		</tbody>
	</table>
	<h4 class="soma">Soma total: <strong class="text-success">R$ <?php echo e(number_format($somaContas, 2, ',', '.')); ?></strong></h4>


</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('relatorios.cabecalho', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcosbueno/Documents/laravel/metronic_multi_8.4/resources/views/relatorios/relatorio_contas_receber.blade.php ENDPATH**/ ?>