@extends('relatorios.cabecalho')
@section('content')
<div class="row">
	<div class="col s12">
		<h3 class="center-align">Relatório de Lista de Preços</h3>
		@if($data)
		<h4>Data: {{$data}}</h4>
		@endif

		<h4>Lista de Preço <strong class="text-primary">{{$lista->nome}}</strong></h4>
		<h4>Percentual de alteração: <strong class="text-danger">{{$lista->percentual_alteracao}}%</strong> sobre o
			@if($lista->tipo == 1)
			valor de compra
			@else
			valor de venda
			@endif
		</h4>
	</div>

	<table class="pure-table">
		<thead>
			<tr>
				<!-- <th width="50">ID</th> -->
				<th width="170">PRODUTO</th>
				<th width="80">VALOR VENDA PADRÃO</th>
				<th width="80">VALOR DE COMPRA</th>
				<th width="80">VALOR DE VENDA LISTA</th>
				<th width="80">% LUCRO</th>
			</tr>
		</thead>

		<tbody>
			@foreach($lista->itens as $i)
			<tr class="datatable-row">
				<td>
					{{$i->produto->nome}}
				</td>
				<td>{{number_format($i->produto->valor_venda, 2, ',', '.')}}
				</td>
				<td>{{number_format($i->produto->valor_compra, 2, ',', '.')}}
				</td>
				<td>{{number_format($i->valor, 2, ',', '.')}}
				</td>
				<td>{{number_format($i->percentual_lucro, 2, ',', '.')}}
				</td>
				
			</tr>
			@endforeach

		</tbody>

	</table>
	<h4>TOTAL DE ITENS: <strong class="text-danger">{{sizeof($lista->itens)}}</strong></h4>
	
</div>
@endsection
