<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="col-md-12">

                    <a href="<?php echo e(route('modelo-etiquetas.create')); ?>" class="btn btn-success">
                        <i class="ri-add-circle-fill"></i>
                        Novo modelo
                    </a>

                    <?php if($importar): ?>
                    <a href="<?php echo e(route('modelo-etiquetas.import')); ?>" class="btn btn-dark">
                        <i class="ri-chat-upload-line"></i>
                        Importar Modelos
                    </a>
                    <?php endif; ?>

                </div>
                <hr class="mt-3">
                <div class="col-lg-12">
                    <?php echo Form::open()->fill(request()->all())
                    ->get(); ?>

                    <div class="row mt-3">
                        <div class="col-md-3">
                            <?php echo Form::text('nome', 'Pesquisar por nome'); ?>

                        </div>
                        <div class="col-md-3 text-left ">
                            <br>
                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="<?php echo e(route('modelo-etiquetas.index')); ?>"><i class="ri-eraser-fill"></i>Limpar</a>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>
                <div class="col-md-12 mt-3 table-responsive">
                    <div class="table-responsive-sm">
                        <table class="table table-striped table-centered mb-0">
                            <thead class="table-dark">
                                <tr>

                                    <th>Nome</th>
                                    <th>Altura</th>
                                    <th>Largura</th>
                                    <th>Observação</th>
                                    <th>Tipo</th>
                                    <th width="20%">Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>

                                    <td><?php echo e($item->nome); ?></td>
                                    <td><?php echo e($item->altura); ?></td>
                                    <td><?php echo e($item->largura); ?></td>
                                    <td><?php echo e($item->observacao); ?></td>
                                    <td><?php echo e($item->tipo == 'simples' ? 'Simples' : 'Gôndola'); ?></td>
                                    <td>
                                        <form action="<?php echo e(route('modelo-etiquetas.destroy', $item->id)); ?>" method="post" id="form-<?php echo e($item->id); ?>">
                                            <?php echo method_field('delete'); ?>
                                            <?php echo csrf_field(); ?>

                                            <a class="btn btn-warning btn-sm" href="<?php echo e(route('modelo-etiquetas.edit', [$item->id])); ?>">
                                                <i class="ri-pencil-fill"></i>
                                            </a>

                                            <button type="button" class="btn btn-delete btn-sm btn-danger">
                                                <i class="ri-delete-bin-line"></i>
                                            </button>

                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="6" class="text-center">Nada encontrado</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                        <br>
                        
                    </div>
                </div>
                <?php echo $data->appends(request()->all())->links(); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.app', ['title' => 'Modelos de etiqueta'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/modelo_etiqueta/index.blade.php ENDPATH**/ ?>