<?php $__env->startSection('content'); ?>
<div class="card mt-1">
    <div class="card-header">
        <h4>Apontamento Produção</h4>
        <div style="text-align: right; margin-top: -35px;">
            <a href="<?php echo e(route('estoque.index')); ?>" class="btn btn-danger btn-sm px-3">
                <i class="ri-arrow-left-double-fill"></i>Voltar
            </a>
        </div>
        <hr>
    </div>
    <div class="card-body">
        <?php echo Form::open()
        ->post()
        ->route('apontamento.store')
        ->multipart(); ?>

        <div class="pl-lg-4">
            <div class="row">
                <div class="col-md-4">
                    <?php echo Form::select('produto_composto_id', 'Produto')
                    ->attrs(['class' => 'form-select'])->required(); ?>

                </div>

                <div class="col-md-2">
                    <?php echo Form::text('quantidade', 'Quantidade')
                    ->attrs(['class' => 'quantidade'])->required(); ?>

                </div>
                <div class="col-1 mt-3" style="text-align: right;">
                    <button type="submit" class="btn btn-success px-5">Salvar</button>
                </div>
            </div>
        </div>
        <?php echo Form::close(); ?>


        <div class="col-md-12 mt-3">
            <div class="table-responsive-sm">
                <table class="table table-centered">
                    <thead class="table-dark">
                        <tr>
                            <th>Produto</th>
                            <th>Quantidade</th>
                            <th>Data Apontamento</th>
                            <th>Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($item->produto->nome); ?></td>
                            <td><?php echo e(number_format($item->quantidade, 3, '.', '')); ?></td>
                            <td><?php echo e(__data_pt($item->created_at, 0)); ?></td>
                            <td>
                                <a class="btn btn-info btn-sm" href="<?php echo e(route('apontamento.imprimir', $item->id)); ?>"><i class="ri-printer-line"></i></a>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="5" class="text-center">Nada encontrado</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['title' => 'Apontamento Produção'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/estoque/apontamento.blade.php ENDPATH**/ ?>