<?php $__env->startSection('css'); ?>
<style type="text/css">
    .div-overflow {
        width: 180px;
        overflow-x: auto;
        white-space: nowrap;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">

                <hr class="mt-3">
                <div class="col-lg-12">
                    <?php echo Form::open()->fill(request()->all())
                    ->get(); ?>

                    <div class="row mt-3 g-1">
                        <div class="col-md-3">
                            <?php echo Form::text('nome', 'Pesquisar por nome'); ?>

                        </div>
                        
                        <div class="col-md-2">
                            <?php echo Form::select('categoria_id', 'Categoria', ['' => 'Selecione'] + $categorias->pluck('nome', 'id')->all())
                            ->attrs(['class' => 'form-select']); ?>

                        </div>

                        <div class="col-md-2">
                            <?php echo Form::select('marca_id', 'Marca', ['' => 'Selecione'] + $marcas->pluck('nome', 'id')->all())
                            ->attrs(['class' => 'form-select']); ?>

                        </div>

                        <div class="col-md-5">
                            <?php echo Form::select('cst_csosn', 'CST/CSOSN', ['' => 'Selecione'] + App\Models\Produto::listaCSTCSOSN())
                            ->attrs(['class' => 'select2']); ?>

                        </div>

                        <div class="col-md-2">
                            <?php echo Form::select('pendentes', 'Dados pendentes', ['' => 'Selecione', 1 => 'Sim', 0 => 'Não'])
                            ->attrs(['class' => 'form-select']); ?>

                        </div>
                        
                        <div class="col-md-3 text-left">
                            <br>
                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="<?php echo e(route('produtos.reajuste')); ?>"><i class="ri-eraser-fill"></i>Limpar</a>
                            
                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>

                <?php if(sizeof($data) > 0): ?>
                <div class="row mt-2">
                    <div class="col-md-2">
                        <?php echo Form::tel('percentual_valor_venda', '% Valor de venda')
                        ->attrs(['class' => '']); ?>

                    </div>
                </div>
                <?php endif; ?>

                <form method="post" action="<?php echo e(route('produtos-reajuste.update')); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="col-md-12 mt-3 table-responsive">
                        <h6>Total de registros: <strong><?php echo e(sizeof($data)); ?></strong></h6>
                        <div class="table-responsive-sm">
                            <table class="table table-striped table-centered mb-0">
                                <thead class="table-dark">
                                    <tr>
                                        <th>Produto</th> 
                                        <th>Categoria</th> 
                                        <th>Valor de venda</th> 
                                        <th>Valor de compra</th> 
                                        <th>CST/CSOSN</th> 
                                        <th>CST PIS</th> 
                                        <th>CST COFINS</th> 
                                        <th>CST IPI</th> 
                                        <th>% ICMS</th> 
                                        <th>% PIS</th> 
                                        <th>% COFINS</th> 
                                        <th>% IPI</th> 
                                        <th>% RED. BC</th> 
                                        <th>CFOP Saída estadual</th> 
                                        <th>CFOP Saída outro estado</th>
                                        <th>CFOP Entrada estadual</th> 
                                        <th>CFOP Entrada outro estado</th>  
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td>
                                            <label style="width: 300px;"><?php echo e($item->nome); ?></label>
                                        </td>
                                        <td>
                                            <label style="width: 200px;"><?php echo e($item->categoria ? $item->categoria->nome : '--'); ?></label>
                                        </td>
                                        <td>
                                            <input type="hidden" name="produto_id[]" value="<?php echo e($item->id); ?>">
                                            <input type="hidden" class="valor_venda" value="<?php echo e($item->valor_unitario); ?>">
                                            <input required style="width: 150px" type="tel" class="form-control moeda valor_venda" name="valor_unitario[]" value="<?php echo e(__moeda($item->valor_unitario)); ?>">
                                            <?php if($loop->first): ?>
                                            <a onclick="setValorVenda()" style="font-size: 12px" href=#!>Definir para os demais itens</a>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <input required style="width: 150px" type="tel" class="form-control moeda valor_compra" name="valor_compra[]" value="<?php echo e(__moeda($item->valor_compra)); ?>">
                                            <?php if($loop->first): ?>
                                            <a onclick="setValorCompra()" style="font-size: 12px" href=#!>Definir para os demais itens</a>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <select required class="select2 cst_csosn" name="cst_csosn[]" style="width: 450px">
                                                <?php $__currentLoopData = App\Models\Produto::listaCSTCSOSN(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option <?php if($key == $item->cst_csosn): ?> selected <?php endif; ?> value="<?php echo e($key); ?>"><?php echo e($v); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <?php if($loop->first): ?>
                                            <a onclick="setCstCsosn()" style="font-size: 12px" href=#!>Definir para os demais itens</a>
                                            <?php endif; ?>

                                            <div style="width: 400px;"></div>
                                        </td>

                                        <td>
                                            <select required class="select2 cst_pis" name="cst_pis[]">
                                                <?php $__currentLoopData = App\Models\Produto::listaCST_PIS_COFINS(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option <?php if($key == $item->cst_pis): ?> selected <?php endif; ?> value="<?php echo e($key); ?>"><?php echo e($v); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <?php if($loop->first): ?>
                                            <a onclick="setCstPis()" style="font-size: 12px" href=#!>Definir para os demais itens</a>
                                            <?php endif; ?>
                                            <div style="width: 400px;"></div>
                                        </td>

                                        <td>
                                            <select required class="select2 cst_cofins" name="cst_cofins[]">
                                                <?php $__currentLoopData = App\Models\Produto::listaCST_PIS_COFINS(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option <?php if($key == $item->cst_cofins): ?> selected <?php endif; ?> value="<?php echo e($key); ?>"><?php echo e($v); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <?php if($loop->first): ?>
                                            <a onclick="setCstCofins()" style="font-size: 12px" href=#!>Definir para os demais itens</a>
                                            <?php endif; ?>
                                            <div style="width: 400px;"></div>
                                        </td>

                                        <td>
                                            <select required class="select2 cst_ipi" name="cst_ipi[]">
                                                <?php $__currentLoopData = App\Models\Produto::listaCST_IPI(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option <?php if($key == $item->cst_ipi): ?> selected <?php endif; ?> value="<?php echo e($key); ?>"><?php echo e($v); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <?php if($loop->first): ?>
                                            <a onclick="setCstIpi()" style="font-size: 12px" href=#!>Definir para os demais itens</a>
                                            <?php endif; ?>
                                            <div style="width: 400px;"></div>
                                        </td>

                                        <td>
                                            <input required style="width: 150px" type="tel" class="form-control percentual perc_icms" name="perc_icms[]" value="<?php echo e($item->perc_icms); ?>">
                                            <?php if($loop->first): ?>
                                            <a onclick="setPercIcms()" style="font-size: 12px" href=#!>Definir para os demais itens</a>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <input required style="width: 150px" type="tel" class="form-control percentual perc_pis" name="perc_pis[]" value="<?php echo e($item->perc_pis); ?>">
                                            <?php if($loop->first): ?>
                                            <a onclick="setPercPis()" style="font-size: 12px" href=#!>Definir para os demais itens</a>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <input required style="width: 150px" type="tel" class="form-control percentual perc_cofins" name="perc_cofins[]" value="<?php echo e($item->perc_cofins); ?>">
                                            <?php if($loop->first): ?>
                                            <a onclick="setPercCofins()" style="font-size: 12px" href=#!>Definir para os demais itens</a>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <input required style="width: 150px" type="tel" class="form-control percentual perc_ipi" name="perc_ipi[]" value="<?php echo e($item->perc_ipi); ?>">
                                            <?php if($loop->first): ?>
                                            <a onclick="setPercIpi()" style="font-size: 12px" href=#!>Definir para os demais itens</a>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <input required style="width: 150px" type="tel" class="form-control percentual perc_red_bc" name="perc_red_bc[]" value="<?php echo e($item->perc_red_bc); ?>">
                                            <?php if($loop->first): ?>
                                            <a onclick="setPercRedBc()" style="font-size: 12px" href=#!>Definir para os demais itens</a>
                                            <?php endif; ?>
                                        </td>

                                        <td>
                                            <input required style="width: 150px" type="tel" class="form-control cfop cfop_saida_estadual" name="cfop_estadual[]" value="<?php echo e($item->cfop_estadual); ?>">
                                            <?php if($loop->first): ?>
                                            <a onclick="setCfopSaidaEstadual()" style="font-size: 12px" href=#!>Definir para os demais itens</a>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <input required style="width: 150px" type="tel" class="form-control cfop cfop_saida_outro_estado" name="cfop_outro_estado[]" value="<?php echo e($item->cfop_outro_estado); ?>">
                                            <?php if($loop->first): ?>
                                            <a onclick="setCfopSaidaOutroEstado()" style="font-size: 12px" href=#!>Definir para os demais itens</a>
                                            <?php endif; ?>
                                        </td>

                                        <td>
                                            <input required style="width: 150px" type="tel" class="form-control cfop cfop_entrada_estadual" name="cfop_entrada_estadual[]" value="<?php echo e($item->cfop_entrada_estadual); ?>">
                                            <?php if($loop->first): ?>
                                            <a onclick="setCfopEntradaEstadual()" style="font-size: 12px" href=#!>Definir para os demais itens</a>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <input required style="width: 150px" type="tel" class="form-control cfop cfop_entrada_outro_estado" name="cfop_entrada_outro_estado[]" value="<?php echo e($item->cfop_entrada_outro_estado); ?>">
                                            <?php if($loop->first): ?>
                                            <a onclick="setCfopEntradaOutroEstado()" style="font-size: 12px" href=#!>Definir para os demais itens</a>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="20" class="text-center">Filtre para buscar os produtos</td>
                                    </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>

                    </div>


                    <div class="col-md-12">
                        <button type="submit" class="btn btn-success float-end mt-3">Salvar</button>
                    </div>
                </form>

                <br>

            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script type="text/javascript">
    $('body').on('blur', '#inp-percentual_valor_venda', function () {

        let percentual = $(this).val()
        $('.valor_venda').each(function (e, x) {
            $vInp = $(this).next()
            let v = parseFloat($(this).val())
            let nv = v + (v*(percentual/100))
            console.log(nv)

            $vInp.val(convertFloatToMoeda(nv))

        })
    })

    $("#inp-percentual_valor_venda").mask("Z999.00", {

        translation: {
            '0': {pattern: /\d/},
            '9': {pattern: /\d/, optional: true},
            'Z': {pattern: /[\-\+]/, optional: true}
        }

    });

    function setValorVenda(){
        let v = $('.valor_venda').first().val()
        $('.valor_venda').val(v)
    }

    function setValorCompra(){
        let v = $('.valor_compra').first().val()
        $('.valor_compra').val(v)
    }
    function setPercIcms(){
        let v = $('.perc_icms').first().val()
        $('.perc_icms').val(v)
    }
    function setPercPis(){
        let v = $('.perc_pis').first().val()
        $('.perc_pis').val(v)
    }
    function setPercCofins(){
        let v = $('.perc_cofins').first().val()
        $('.perc_cofins').val(v)
    }
    function setPercIpi(){
        let v = $('.perc_ipi').first().val()
        $('.perc_ipi').val(v)
    }
    function setPercRedBc(){
        let v = $('.perc_red_bc').first().val()
        $('.perc_red_bc').val(v)
    }
    function setCfopSaidaEstadual(){
        let v = $('.cfop_saida_estadual').first().val()
        $('.cfop_saida_estadual').val(v)
    }
    function setCfopSaidaOutroEstado(){
        let v = $('.cfop_saida_outro_estado').first().val()
        $('.cfop_saida_outro_estado').val(v)
    }
    function setCfopEntradaEstadual(){
        let v = $('.cfop_entrada_estadual').first().val()
        $('.cfop_entrada_estadual').val(v)
    }
    function setCfopEntradaOutroEstado(){
        let v = $('.cfop_entrada_outro_estado').first().val()
        $('.cfop_entrada_outro_estado').val(v)
    }

    function setCstCsosn(){
        let v = $('.cst_csosn').first().val()
        $('.cst_csosn').val(v).change()
    }
    function setCstPis(){
        let v = $('.cst_pis').first().val()
        $('.cst_pis').val(v).change()
    }
    function setCstCofins(){
        let v = $('.cst_cofins').first().val()
        $('.cst_cofins').val(v).change()
    }
    function setCstIpi(){
        let v = $('.cst_ipi').first().val()
        $('.cst_ipi').val(v).change()
    }
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', ['title' => 'Reajuste de Produtos'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/produtos/reajuste.blade.php ENDPATH**/ ?>