<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <h4>Detalhes da Venda</h4>
                <div style="text-align: right; margin-top: -35px;">
                    <a href="<?php echo e(route('frontbox.index')); ?>" class="btn btn-danger btn-sm px-3">
                        <i class="ri-arrow-left-double-fill"></i>Voltar
                    </a>
                </div>
                <hr class="mt-3">

                <a class="btn btn-dark mb-2" title="Imprimir" target="_blank" href="<?php echo e(route('frontbox.imprimir-nao-fiscal', [$data->id])); ?>">
                    Imprimir
                    <i class="ri-printer-line"></i>
                </a>
                <div class="">
                    <h4>Cliente: <strong style="color: steelblue"><?php echo e($data->cliente_id ? $data->cliente->razao_social : 'Consumidor Final'); ?></strong></h4>

                    <?php if($data->user): ?>
                    <h5>Usuário: <strong class="text-"><?php echo e($data->user->name); ?></strong></h5>
                    <?php endif; ?>
                </div>
                <hr>
                <div class="col-lg-12 mt-4">
                    <div class="table-responsive-sm">
                        <h5>Produtos:</h5>
                        <table class="table table-striped table-centered mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <th>Produto</th>
                                    <th>Qtd</th>
                                    <th>Valor</th>
                                    <th>Sub Total</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $data->itens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($item->produto->nome); ?></td>
                                    <td><?php echo e($item->quantidade); ?></td>
                                    <td><?php echo e(__moeda($item->valor_unitario)); ?></td>
                                    <td><?php echo e(__moeda($item->sub_total)); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="7" class="text-center">Nada encontrado</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                        <h5 class="mt-2">TOTAL: <?php echo e(__moeda($data->total)); ?> </h5>
                    </div>
                    <div class="mt-5 col-md-6 col-12">
                        <h5>Forma de Pagamento:</h5>
                        <table class="table table-striped table-centered mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <th>Pagamento</th>
                                    <th>Data Vencimento</th>
                                    <th>Valor</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $data->fatura; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($item->getTipoPagamento($item->tipo_pagamento)); ?></td>
                                    <td><?php echo e(__data_pt($item->data_vencimento, 0)); ?></td>
                                    <td><?php echo e(__moeda($item->valor)); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="7" class="text-center">Nada encontrado</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['title' => 'Detalhes da Venda'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/front_box/show.blade.php ENDPATH**/ ?>