<?php $__env->startSection('content'); ?>

<?php $__env->startSection('css'); ?>
<style type="text/css">
    input[type="file"] {
        display: none;
    }

    .file-certificado label {
        padding: 8px 8px;
        width: 100%;
        background-color: #8833FF;
        color: #FFF;
        text-transform: uppercase;
        text-align: center;
        display: block;
        margin-top: 20px;
        cursor: pointer;
        border-radius: 5px;
    }

    .card-body strong {
        color: #8833FF;
    }

</style>
<?php $__env->stopSection(); ?>


<div class="card mt-3">
    <div class="card-header">
        <h4>Alterar Estado Fiscal NFCe</h4>
        <div style="text-align: right; margin-top: -35px;">
            <a href="<?php echo e(route('nfce.index')); ?>" class="btn btn-danger btn-sm px-3">
                <i class="ri-arrow-left-double-fill"></i>Voltar
            </a>
        </div>
    </div>
    <div class="row">
        <?php echo Form::open()
        ->put()
        ->route('nfce.storeEstado', [$item->id])
        ->multipart(); ?>

        <hr>
        <div class="m-3">
            <h5>Cliente: <strong class="text-primary"> <?php echo e($item->cliente ? $item->cliente->razao_social : 'Consumidor Final'); ?></strong></h5>
            <h6>CNPJ: <strong class="text-success"><?php echo e($item->cliente ? $item->cliente->cpf_cnpj : '--'); ?></strong></h6>
            <h6>Data: <strong class="text-success"> <?php echo e(__data_pt($item->data_registro, 0)); ?></strong></h6>
            <h6>Valor Total: <strong class="text-success"> <?php echo e(__moeda($item->total)); ?></strong></h6>
            <?php if($item->cliente): ?>
            <h6>Cidade: <strong class="text-success"> <?php echo e($item->cliente->cidade->nome); ?> (<?php echo e($item->cliente->cidade->uf); ?>)</strong></h6>
            <?php endif; ?>
            <h6>Chave NFCe: <strong class="text-success"> <?php echo e($item->chave != "" ? $item->chave : '--'); ?></strong></h6>
        </div>
        <hr>
        <div class="row m-3">
            <div class="col-md-3">
                <?php echo Form::select('estado_emissao', 'Estado',
                ['novo' => 'Novo', 'rejeitado' => 'Rejeitado', 'cancelado' => 'Cancelado', 'aprovado' => 'Aprovado'])
                ->attrs(['class' => 'form-select'])->value(isset($item) ? $item->estado : ''); ?>

            </div>
            <div class="col-md-6">
                <div class="col-md-5 file-certificado">
                    <?php echo Form::file('file', 'Arquivo XML')
                    ->attrs(['accept' => '.xml']); ?>

                    <span class="text-danger" id="filename"></span>
                </div>
            </div>
            <div class="col-12 mt-3">
                <button type="submit" class="btn btn-primary px-5">Salvar</button>
            </div>
        </div>
        <?php echo Form::close(); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['title' => 'Alterar Estado Fiscal NFCe'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/nfce/estado_fiscal.blade.php ENDPATH**/ ?>