<?php $__env->startSection('css'); ?>
<style type="text/css">
	.w-100{
		width: 100%;
		margin-bottom: 10px;
	}
</style>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="section">
	<!-- container -->
	<div class="container">
		<!-- row -->
		<div class="row">
			<!-- Product main img -->
			<div class="col-md-5 col-md-push-2">
				<div id="product-main-img">
					<div class="product-preview">
						<img src="<?php echo e($produto->img); ?>">
					</div>
					<?php $__currentLoopData = $produto->galeria; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $g): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<div class="product-preview">
						<img src="<?php echo e($g->img); ?>">
					</div>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</div>
			</div>
			<!-- /Product main img -->

			<!-- Product thumb imgs -->
			<div class="col-md-2  col-md-pull-5">
				<div id="product-imgs">
					<div class="product-preview">
						<img src="<?php echo e($produto->img); ?>">
					</div>
					<?php $__currentLoopData = $produto->galeria; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $g): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<div class="product-preview">
						<img src="<?php echo e($g->img); ?>">
					</div>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

				</div>
			</div>
			<!-- /Product thumb imgs -->

			<!-- Product details -->
			<div class="col-md-5">
				<div class="product-details">
					<h2 class="product-name"><?php echo e($produto->nome); ?></h2>
					
					<div>
						<h3 class="product-price">R$<?php echo e(__moeda($produto->valor_ecommerce)); ?>

							<?php if($produto->percentual_desconto > 0): ?>
							<del class="product-old-price">
								R$ <?php echo e(__moeda($produto->valor_ecommerce + ($produto->valor_ecommerce*$produto->percentual_desconto/100))); ?>

							</del>
							<?php endif; ?>
						</h3>
						<span class="product-available">Em estoque</span>
					</div>
					<p><?php echo e($produto->descricao_ecommerce); ?></p>

					<form method="post" action="<?php echo e(route('loja.adicionar-carrinho')); ?>">
						<input type="hidden" name="link" value="<?php echo e($config->loja_id); ?>">
						<input type="hidden" name="produto_id" value="<?php echo e($produto->id); ?>">
						<?php echo csrf_field(); ?>
						<?php if(sizeof($produto->variacoes) > 0): ?>
						<div class="product-options">
							<label>
								Selecione
								<select id="variacao_id" name="variacao_id" class="input-select" style="width: 100%">
									<?php $__currentLoopData = $produto->variacoes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<option value="<?php echo e($v->id); ?>"><?php echo e($v->descricao); ?></option>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</select>
							</label>
						</div>
						<?php endif; ?>

						<div class="add-to-cart">
							<div class="qty-label">
								Quantidade
								<div class="input-number">
									<input name="quantidade" type="number" value="1">
									<span class="qty-up">+</span>
									<span class="qty-down">-</span>
								</div>
							</div><br>
							<button class="add-to-cart-btn" style="margin-top: 20px"><i class="fa fa-shopping-cart"></i>Adicionar ao carrinho</button>
						</div>
					</form>

					<?php if($produto->categoria): ?>
					<ul class="product-links">
						<li>Categoria:</li>
						<li><a href="#"><?php echo e($produto->categoria->nome); ?></a></li>
					</ul>
					<?php endif; ?>

				</div>
			</div>
			<!-- /Product details -->

			<!-- Product tab -->
			<div class="col-md-12">
				<div id="product-tab">
					<!-- product tab nav -->

					<!-- /product tab nav -->

					<!-- product tab content -->
					<div class="tab-content">
						<!-- descrição  -->
						<div id="tab1" class="tab-pane fade in active">
							<div class="row">
								<div class="col-md-12">
									<?php echo $produto->texto_ecommerce; ?>

								</div>
							</div>
						</div>


					</div>
					<!-- /product tab content  -->
				</div>
			</div>
			<!-- /product tab -->
		</div>
		<!-- /row -->
	</div>
	<!-- /container -->
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script type="text/javascript">
	$(function(){
		getVariacao()
	})

	$(document).on("change", "#variacao_id", function () {
		getVariacao()
	})

	function getVariacao(){
		let variacao_id = $('#variacao_id').val()
		$.get(path_url+'api/ecommerce/variacao/', {variacao_id: variacao_id})
		.done((success) => {
			$('.product-price').html('R$'+convertFloatToMoeda(success.valor))
		})
		.fail((err) => {
			console.log(err)
		})
	}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('loja.default', ['title' => $produto->nome], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/loja/produtos_detalhe.blade.php ENDPATH**/ ?>