<?php $__env->startSection('css'); ?>
<style type="text/css">
    td:hover{
        cursor: pointer;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="col-md-2">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pre_venda_create')): ?>
                    <a href="<?php echo e(route('pre-venda.create')); ?>" class="btn btn-success">
                        <i class="ri-add-circle-fill"></i>
                        Nova Pré venda
                    </a>
                    <?php endif; ?>
                </div>
                <hr class="mt-3">
                <div class="col-lg-12">
                    <?php echo Form::open()->fill(request()->all())
                    ->get(); ?>

                    <div class="row mt-3 g-1">
                        <div class="col-md-4">
                            <?php echo Form::select('cliente_id', 'Pesquisar por nome')->attrs(['class' => 'select2']); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::text('codigo', 'Pesquisar por código'); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::date('start_date', 'Data inicial'); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::date('end_date', 'Data final'); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::select('status', 'Estado',
                            ['1' => 'Não recebidas',
                            '-1' => 'Recebidas'])
                            ->attrs(['class' => 'form-select']); ?>

                        </div>

                        <?php if(__countLocalAtivo() > 1): ?>
                        <div class="col-md-2">
                            <?php echo Form::select('local_id', 'Local', ['' => 'Selecione'] + __getLocaisAtivoUsuario()->pluck('descricao', 'id')->all())
                            ->attrs(['class' => 'select2']); ?>

                        </div>
                        <?php endif; ?>
                        <div class="col-md-3 text-left">
                            <br>
                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="<?php echo e(route('pre-venda.index')); ?>"><i class="ri-eraser-fill"></i>Limpar</a>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>
                <div class="col-12 mt-3">
                    <div class="table-responsive-sm">
                        <table class="table table-centered">
                            <thead class="table-dark">
                                <tr>
                                    <th>Código</th>
                                    <th>Cliente</th>
                                    <?php if(__countLocalAtivo() > 1): ?>
                                    <th>Local</th>
                                    <?php endif; ?>
                                    <th>Data</th>
                                    <th>Valor</th>
                                    <th>Status</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr ondblclick="finalizar('<?php echo e($item->id); ?>')">
                                    <td width="200"><?php echo e($item->codigo); ?></td>
                                    <td width="600"><?php echo e($item->cliente_id ? $item->cliente->razao_social : 'Consumidor Final'); ?></td>
                                    <?php if(__countLocalAtivo() > 1): ?>
                                    <td class="text-danger"><?php echo e($item->localizacao->descricao); ?></td>
                                    <?php endif; ?>
                                    <td width="200"><?php echo e(__data_pt($item->created_at)); ?></td>
                                    <td width="200"><?php echo e(__moeda($item->valor_total)); ?></td>
                                    <td width="150">
                                        <?php if($item->status == false): ?>
                                        <i class="ri-checkbox-circle-fill text-success"></i>
                                        <?php else: ?>
                                        <i class="ri-close-circle-fill text-danger"></i>
                                        <?php endif; ?>
                                    </td>
                                    <td style="width: 280px">
                                        <form action="<?php echo e(route('pre-venda.destroy', $item->id)); ?>" method="post" id="form-<?php echo e($item->id); ?>">
                                            <?php echo method_field('delete'); ?>
                                            <?php echo csrf_field(); ?>
                                            <?php if($item->status == 1): ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pre_venda_delete')): ?>
                                            <button type="button" class="btn btn-delete btn-sm btn-danger">
                                                <i class="ri-delete-bin-line"></i>
                                            </button>
                                            <?php endif; ?>
                                            <?php endif; ?>

                                            <?php if($item->status == 0 && $item->venda_id != null && $item->tipo_finalizado == 'nfe'): ?>

                                            <a type="button" class="btn btn-light info btn-sm" title="Ver NFe" href="<?php echo e(route('nfe.show', $item->venda_id)); ?>">
                                                <i class="ri-eye-line"></i>
                                            </a>
                                            <a class="btn btn-primary btn-sm" title="Imprimir pedido" target="_blank" href="<?php echo e(route('nfe.imprimir', [$item->venda_id])); ?>">
                                                <i class="ri-printer-line"></i>
                                            </a>

                                            <?php endif; ?>

                                            <?php if($item->status == 0 && $item->venda_id != null && $item->tipo_finalizado == 'nfce'): ?>

                                            <a type="button" class="btn btn-light info btn-sm" title="Ver NFCe" href="<?php echo e(route('nfce.show', $item->venda_id)); ?>">
                                                <i class="ri-eye-line"></i>
                                            </a>

                                            <?php if($item->tipo_finalizado == 'nfe' && $item->venda_id != null ): ?>
                                            <a class="btn btn-primary btn-sm" title="Imprimir NFCe" target="_blank" href="<?php echo e(route('nfce.imprimir', [$item->venda_id])); ?>">
                                                <i class="ri-printer-line"></i>
                                            </a>

                                            <?php elseif($item->tipo_finalizado == 'nfce' && $item->venda_id != null): ?>
                                            <a class="btn btn-success btn-sm" title="Imprimir Pedido" target="_blank" href="<?php echo e(route('frontbox.imprimir-nao-fiscal', [$item->venda_id])); ?>">
                                                <i class="ri-printer-line"></i>
                                            </a>

                                            <?php if($item->nfce && $item->nfce->estado == 'aprovado'): ?>
                                            <a class="btn btn-primary btn-sm" title="Imprimir Nfc-e" target="_blank" href="<?php echo e(route('nfce.imprimir', [$item->venda_id])); ?>">
                                                <i class="ri-printer-line"></i>
                                            </a>
                                            <?php endif; ?>

                                            <?php endif; ?>
                                            <?php endif; ?>

                                            <?php if($item->status == 1): ?>
                                            <button type="button" class="btn btn-dark btn-sm" title="Finalizar" onclick="finalizar('<?php echo e($item->id); ?>')">
                                                <i class="ri-coins-fill"></i>
                                            </button>
                                            <?php endif; ?>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php echo $data->appends(request()->all())->links(); ?>

            </div>
        </div>
    </div>
</div>
<?php echo $__env->make('modals._finalizar_pre_venda', ['not_submit' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="/js/pre_venda.js"></script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.app', ['title' => 'Lista de Pré vendas'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/pre_venda/index.blade.php ENDPATH**/ ?>