<?php $__env->startSection('css'); ?>
<style type="text/css">
	.card-hover:hover{
		cursor: pointer;
	}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="mt-3">
	<div class="row">
		<div id="print"></div>
		
		<div class="col-12 col-lg-4">
			<div class="card">
				<div class="card-body">

					<form class="row" method="post" action="<?php echo e(route('pedidos-cardapio.store-item', [$item->id])); ?>">
						<?php echo csrf_field(); ?>

						<input type="hidden" id="tipo_divisao_pizza" value="<?php echo e($config != null ? $config->valor_pizza : 'divide'); ?>">
						<div class="col-md-12">
							<?php echo Form::select('produto_cardapio', 'Produto')->required()
							->attrs(['class' => 'produto_cardapio']); ?>

						</div>

						<div class="col-md-6 col-12 mt-2">
							<?php echo Form::tel('quantidade', 'Quantidade')
							->required()
							->attrs(['class' => 'moeda']); ?>

						</div>

						<div class="col-md-6 col-12 mt-2">
							<?php echo Form::tel('valor_unitario', 'Valor unitário')
							->required()
							->attrs(['class' => 'moeda']); ?>

						</div>

						<div class="col-md-12 mt-2">
							<button type="button" class="btn w-100 btn-dark" id="btn-adicionais">
								<i class="ri-shopping-basket-fill"></i>
								Definir adicionais
							</button>
						</div>

						<div class="col-md-12 mt-2 adicionaisescolhidos">
						</div>

						<div class="col-md-12 col-12 mt-2">
							<?php echo Form::text('observacao', 'Observação'); ?>

						</div>

						<div class="col-12 mt-2 div-tp-carne d-none">
							<?php echo Form::select('ponto_carne', 'Ponto da carne', ['' => 'Selecione'] +  App\Models\Produto::pontosDaCarne())
							->attrs(['class' => 'form-select']); ?>

						</div>

						<div class="col-md-6 col-12 mt-2">
							<?php echo Form::tel('sub_total', 'Subtotal')
							->required()
							->readonly()
							->attrs(['class' => 'moeda']); ?>

						</div>

						<div class="col-md-6 col-12 mt-2">
							<?php echo Form::select('estado', 'Estado', 
							[
							'novo' => 'Novo', 
							'pendente' => 'Pendente', 
							'preparando' => 'Preparando', 
							'finalizado' => 'Finalizando'
							])
							->attrs(['class' => 'form-select'])
							->required(); ?>

						</div>

						<input type="hidden" id="adicionais-hidden" name="adicionais">
						<input type="hidden" id="pizzas-hidden" name="pizzas">
						<input type="hidden" id="tamanho_id-hidden" name="tamanho_id">
						<div class="col-md-12 col-12 mt-4">
							<button type="submit" class="btn w-100 btn-success">
								<i class="ri-checkbox-circle-fill"></i>
								Adicionar
							</button>
						</div>
					</form>
				</div>
			</div>
		</div>

		<div class="col-12 col-lg-8">
			<div class="card">
				<div class="card-body">
					<div class="col-12">
						<h3>ITENS <strong class="text-success">#<?php echo e($item->comanda); ?></strong></h3>

						<button class="float-end btn btn-dark" onclick="print('<?php echo e($item->id); ?>')">
							<i class="ri-printer-line"></i>
							Imprimir
						</button>
					</div>

					
					<div class="table-responsive col-12" style="min-height: 300px;">
						<table class="table">
							<thead>
								<tr>
									<th>Produto</th>
									<th>Quantidade</th>
									<th>Valor unitário</th>
									<th>Subtotal</th>
									<th>Observação</th>
									<th>Ações</th>
								</tr>
							</thead>
							<tbody>
								<?php $__currentLoopData = $item->itens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<tr class="bg-<?php echo e($i->estado); ?>">
									<td>
										<?php echo e($i->produto->nome); ?>

										<?php if($i->funcionario): ?>
										<br> <span style="color: red; font-size: 11px">garçom: <?php echo e($i->funcionario->nome); ?></span>
										<?php endif; ?>
									</td>
									<td><?php echo e(__moeda($i->quantidade)); ?></td>
									<td><?php echo e(__moeda($i->valor_unitario)); ?></td>
									<td><?php echo e(__moeda($i->sub_total)); ?></td>
									<td>
										<?php if($i->observacao == ''): ?>
										<button class="btn btn-sm">
											<i class="ri-sticky-note-line"></i>
										</button>
										<?php else: ?>
										<button class="btn btn-sm btn-dark" onclick="noteSwal('<?php echo e($i->observacao); ?>')">
											<i class="ri-sticky-note-line"></i>
										</button>
										<?php endif; ?>
									</td>
									<td>
										<form action="<?php echo e(route('pedidos-cardapio.destroy-item', $i->id)); ?>" method="post" id="form-<?php echo e($i->id); ?>">
											<?php echo csrf_field(); ?>
											<?php echo method_field('delete'); ?>
											<button type="submit" title="Deletar" class="btn btn-danger btn-delete btn-sm"><i class="ri-delete-bin-2-line"></i></button>
										</form>
									</td>
								</tr>
								<?php if(sizeof($i->adicionais) > 0): ?>
								<tr>
									<td></td>
									<td colspan="5" style="font-weight: bold; font-size: 13px;">Adicionais: <?php echo e($i->getAdicionaisStr()); ?></td>
								</tr>
								<?php endif; ?>

								<?php if($i->ponto_carne): ?>
								<tr>
									<td></td>
									<td colspan="5" style="font-weight: bold; font-size: 13px;">Ponto da carme: <strong class="text-success"><?php echo e($i->ponto_carne); ?></strong></td>
								</tr>
								<?php endif; ?>

								<?php if(sizeof($i->pizzas) > 0): ?>
								<tr>
									<td></td>
									<td colspan="5" style="font-weight: bold; font-size: 13px;">Sabores: 
										<strong class="text-success">
											<?php $__currentLoopData = $i->pizzas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											1/<?php echo e(sizeof($i->pizzas)); ?> <?php echo e($s->sabor->nome); ?>

											<?php if(!$loop->last): ?>
											|
											<?php endif; ?>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										</strong>

										<span> - Tamanho: <strong class="text-info"><?php echo e($i->tamanho ? $i->tamanho->nome : '--'); ?></strong></span>
									</td>
								</tr>
								<?php endif; ?>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</tbody>
						</table>
					</div>	

					<div class="row">
						<h5>estados dos itens</h5>
						<div class="col-lg-3 col-6">
							<h6 class="text-novo">
								<i class="ri-flag-2-fill"></i> novo
							</h6>
						</div>

						<div class="col-lg-3 col-6">
							<h6 class="text-pendente">
								<i class="ri-flag-2-fill"></i> pendente
							</h6>
						</div>

						<div class="col-lg-3 col-6">
							<h6 class="text-preparando">
								<i class="ri-flag-2-fill"></i> preparando
							</h6>
						</div>

						<div class="col-lg-3 col-6">
							<h6 class="text-finalizado">
								<i class="ri-flag-2-fill"></i> finalizado
							</h6>
						</div>
					</div>
					<hr>
					<div class="col-12">
						<a class="btn btn-lg btn-primary pull-right <?php if(!$item->status): ?> disabled <?php endif; ?>" href="<?php echo e(route('pedidos-cardapio.finish', [$item->id])); ?>">
							<i class="ri-shopping-cart-2-line"></i>
							Finalizar <strong style="font-size: 25px; margin-left: 15px">R$ <?php echo e(__moeda($item->total)); ?></strong>
						</a>
					</div>

					<div style="text-align: right; margin-top: -40px;">
						<a href="<?php echo e(route('pedidos-cardapio.index')); ?>" class="btn btn-sm btn-danger btn-sm px-3">
							<i class="ri-arrow-left-double-fill"></i>Voltar
						</a>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<div class="modal fade" id="modal-adicionais" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
	<div class="modal-dialog modal-xl">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleModalLabel">Adicionais</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
				<div class="row adicionais">


				</div>

				<h4 class="mt-3">Subtotal: <strong class="subtotal_modal"></strong></h4>

			</div>
			<div class="modal-footer">
				<button id="btn-save-modal" type="button" class="btn btn-success" data-bs-dismiss="modal">Salvar</button>
			</div>
		</div>
	</div>
</div>

<div class="modal fade" id="modal-pizza" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
	<div class="modal-dialog modal-xl">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleModalLabel">Selecione os sabores</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
				<div class="row m-2">
					<p class="text-danger">*selecione o tamanho para buscar os sabores</p>
					<div class="col-md-5 col-6">
						<?php echo Form::select('tamanho_id', 'Tamanho', ['' => 'Selecione'] + 
						$tamanhosPizza->pluck('info', 'id')->all())
						->attrs(['class' => 'form-select']); ?>

					</div>
				</div>
				<div class="row pizzas m-2 mt-4">
				</div>

				<div class="col-md-2 col-6 m-2 mt-3">
					<?php echo Form::tel('subtotal_modal', 'Subtotal')
					->required()
					->attrs(['class' => 'moeda']); ?>

				</div>
			</div>
			<div class="modal-footer">
				<button id="btn-save-sabores" type="button" class="btn btn-success">Salvar</button>
			</div>
		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script type="text/javascript" src="/js/pedido.js"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['title' => 'Comanda ' . $item->comanda], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/pedidos/show.blade.php ENDPATH**/ ?>