<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">

                <hr class="mt-3">
                <div class="col-lg-12">
                    <?php echo Form::open()->fill(request()->all())
                    ->get(); ?>


                    <div class="row mt-3">
                        <div class="col-md-3">
                            <?php echo Form::select('empresa', 'Pesquisar por empresa')
                            ->options($empresa ? [$empresa->id => $empresa->info] : []); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::date('start_date', 'Data inicial'); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::date('end_date', 'Data final'); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::select('status_pagamento', 'Status de pagamento', ['' => 'Selecione'] + \App\Models\FinanceiroPlano::statusDePagamentos())
                            ->attrs(['class' => 'form-select']); ?>

                        </div>
                        <div class="col-md-3 text-left ">
                            <br>
                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="<?php echo e(route('financeiro-plano.index')); ?>"><i class="ri-eraser-fill"></i>Limpar</a>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>
                <div class="col-md-12 mt-3">
                    <div class="table-responsive-sm">
                        <table class="table table-centered">
                            <thead class="table-dark">
                                <tr>
                                    <th>Empresa</th>
                                    <th>Plano</th>
                                    <th>Valor</th>
                                    <th>Tipo de pagamento</th>
                                    <th>Data de cadastro</th>
                                    <th>Status</th>

                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>

                                    <td><?php echo e($item->empresa->info); ?></td>
                                    <td><?php echo e($item->plano->nome); ?></td>
                                    <td><?php echo e(__moeda($item->valor)); ?></td>
                                    <td>
                                        <?php echo e($item->tipo_pagamento); ?>

                                    </td>

                                    <td><?php echo e(__data_pt($item->created_at, 1)); ?></td>
                                    <td><?php echo e(strtoupper($item->status_pagamento)); ?></td>
                                    <td>

                                        <form action="<?php echo e(route('financeiro-plano.destroy', $item->id)); ?>" method="post" id="form-<?php echo e($item->id); ?>">
                                            <?php echo method_field('delete'); ?>
                                            <?php echo csrf_field(); ?>
                                            <button type="button" class="btn btn-delete btn-sm btn-danger">
                                                <i class="ri-delete-bin-line"></i>
                                            </button>

                                            <a class="btn btn-warning btn-sm" href="<?php echo e(route('financeiro-plano.edit', [$item->id])); ?>">
                                                <i class="ri-pencil-fill"></i>
                                            </a>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-4">
                        <h5>Soma recebido: <strong class="text-success">R$ <?php echo e(__moeda($somaRecebido)); ?></strong></h5>
                    </div>
                    <div class="col-md-4">
                        <h5>Soma pendente: <strong class="text-warning">R$ <?php echo e(__moeda($somaPendente)); ?></strong></h5>
                    </div>
                    <div class="col-md-4">
                        <h5>Soma cancelado: <strong class="text-danger">R$ <?php echo e(__moeda($somaCancelado)); ?></strong></h5>
                    </div>
                </div>
                <?php echo $data->appends(request()->all())->links(); ?>


            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', ['title' => 'Financeiro Planos'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/financeiro_plano/index.blade.php ENDPATH**/ ?>