<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">

                <div class="row">
                    <div class="col-md-12">
                        <a href="<?php echo e(route('manifesto.novaConsulta')); ?>" class="btn btn-dark">
                            <i class="ri-refresh-line"></i>
                            Nova Consulta de Documentos
                        </a>
                    </div>
                </div>
                <hr class="mt-3">
                <div class="col-lg-12">
                    <?php echo Form::open()->fill(request()->all())
                    ->get(); ?>

                    <div class="row mt-3">
                        <div class="col-md-2">
                            <?php echo Form::date('start_date', 'Data inicial'); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::date('end_date', 'Data final'); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::select('tipo', 'Tipo',
                            [
                            '' => 'Todos',
                            1 => 'Ciência',
                            2 => 'Confirmada',
                            3 => 'Desconhecido',
                            4 => 'Op. não Realizada'])
                            ->attrs(['class' => 'form-select']); ?>

                        </div>
                        <div class="col-lg-4 col-12">
                            <br>
                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="<?php echo e(route('manifesto.index')); ?>"><i class="ri-eraser-fill"></i>Limpar</a>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>
                <div class="col-md-12 mt-3">
                    <div class="table-responsive">
                        <table class="table table-centered">
                            <thead class="table-dark">
                                <tr>
                                    <th>Nome</th>
                                    <th>Documento</th>
                                    <th>Valor</th>
                                    <th>Data</th>
                                    <th>Num. Protocolo</th>
                                    <th>Chave</th>
                                    <th>Estado</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($item->nome); ?></td>
                                    <td><?php echo e($item->documento); ?></td>
                                    <td><?php echo e(__moeda($item->valor)); ?></td>
                                    <td><?php echo e(__data_pt($item->data_emissao)); ?></td>
                                    <td><?php echo e($item->num_prot); ?></td>
                                    <td><?php echo e($item->chave); ?></td>
                                    <td><?php echo e($item->estado()); ?></td>
                                    <td>
                                        <?php if($item->tipo == 1 || $item->tipo == 2): ?>
                                        <a href="<?php echo e(route('manifesto.download', [$item->id])); ?>" class="btn btn-success btn-sm w-100">Completa</a>
                                        <a target="_blank" href="<?php echo e(route('manifesto.danfe', [$item->id])); ?>" class="btn btn-primary btn-sm w-100 mt-1">Imprimir</a>

                                        <?php elseif($item->tipo == 3): ?>
                                        <a class="btn btn-danger w-100">Desconhecida</a>
                                        <?php elseif($item->tipo == 4): ?>
                                        <a class="btn btn-warning w-100">Não realizada</a>
                                        <?php endif; ?>
                                        <?php if($item->tipo != 2): ?>
                                        <a class="btn btn-info btn-sm w-100 mt-1" onclick="setChave('<?php echo e($item->chave); ?>')" data-toggle="modal" data-target="#modal-evento">Manifestar</a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <?php echo $data->appends(request()->all())->links(); ?>

                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal-evento" aria-modal="true" role="dialog" style="overflow:scroll;" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <form class="modal-content" method="post" action="<?php echo e(route('manifesto.manifestar')); ?>">
            <?php echo csrf_field(); ?>
            <div class="modal-header">
                <h5 class="modal-title">Manifestação NFe</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <input type="hidden" name="chave" id="chave">
                <div class="col-md-6">
                    <?php echo Form::select('tipo', 'Tipo', [1 => "Ciencia", 2 => "Confirmação", 3 => "Desconhecimento", 4 => "Operação não realizada"])
                    ->attrs(['class' => 'form-select']); ?>

                </div>

                <div class="col-md-12 just d-none mt-3">
                    <?php echo Form::text('justificativa', 'Justificativa'); ?>

                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-info px-5">Manifestar</button>
            </div>
        </form>
    </div>
</div>

<?php $__env->startSection('js'); ?>
<script type="text/javascript">
    function setChave(chave) {
        $('#chave').val(chave)
        $('#modal-evento').modal('show')
    }

    $(document).on("change", "#inp-tipo", function() {
        if ($(this).val() > 2) {
            $('.just').removeClass('d-none')
        } else {
            $('.just').addClass('d-none')
        }
    })

</script>
<?php $__env->stopSection(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['title' => 'Manifesto'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/manifesto/index.blade.php ENDPATH**/ ?>