<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-2">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('troca_create')): ?>
                        <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#modal-nova-troca">
                            <i class="ri-add-circle-fill"></i>
                            Nova Troca
                        </button>
                        <?php endif; ?>
                    </div>
                    <div class="col-md-8"></div>

                </div>
                
                <hr class="mt-3">
                <div class="col-lg-12">
                    <?php echo Form::open()->fill(request()->all())
                    ->get(); ?>

                    <div class="row mt-3">
                        <div class="col-md-4">
                            <?php echo Form::select('cliente_id', 'Cliente')
                            ->attrs(['class' => 'select2']); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::date('start_date', 'Data inicial'); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::date('end_date', 'Data final'); ?>

                        </div>
                        

                        <div class="col-md-4">
                            <br>

                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="<?php echo e(route('trocas.index')); ?>"><i class="ri-eraser-fill"></i>Limpar</a>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>
                <div class="col-lg-12 mt-4">
                    <div class="table-responsive-sm">
                        <table class="table table-striped table-centered mb-0">
                            <thead class="table-dark">
                                <tr>

                                    <th>#</th>
                                    <th>Cliente</th>
                                    <th>Código</th>
                                    <th>Valor da troca</th>
                                    <th>Valor da venda</th>
                                    <th>Data da troca</th>
                                    <th>Venda ID</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($item->numero_sequencial); ?></td>
                                    <td><label style="width: 400px;"><?php echo e($item->nfce->cliente ? $item->nfce->cliente->razao_social : "--"); ?></label></td>
                                    
                                    <td><?php echo e($item->codigo); ?></td>
                                    <td><?php echo e(number_format($item->valor_troca, 2, ',', '.')); ?></td>
                                    <td><?php echo e(number_format($item->valor_original, 2, ',', '.')); ?></td>

                                    <td><label style="width: 120px"><?php echo e(__data_pt($item->created_at)); ?></label></td>
                                    <td><?php echo e($item->nfce ? $item->nfce->numero_sequencial : ''); ?></td>
                                    
                                    <td>
                                        <form action="<?php echo e(route('trocas.destroy', $item->id)); ?>" method="post" id="form-<?php echo e($item->id); ?>" style="width: 320px">
                                            <?php echo method_field('delete'); ?>
                                            <?php echo csrf_field(); ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('troca_delete')): ?>
                                            <button type="button" class="btn btn-danger btn-sm btn-delete">
                                                <i class="ri-delete-bin-line"></i>
                                            </button>
                                            <?php endif; ?>

                                            <a class="btn btn-ligth btn-sm" title="Detalhes" href="<?php echo e(route('trocas.show', $item->id)); ?>"><i class="ri-eye-line"></i></a>

                                            <a target="_blank" class="btn btn-dark btn-sm" title="Detalhes" href="<?php echo e(route('trocas.imprimir', $item->id)); ?>">
                                                <i class="ri-printer-line"></i>
                                            </a>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="9" class="text-center">Nada encontrado</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <br>
                <?php echo $data->appends(request()->all())->links(); ?>

            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal-nova-troca" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form method="get" action="<?php echo e(route('trocas.create')); ?>">
            <div class="modal-content">

                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Nova troca</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">

                        <div class="col-md-12">
                            <?php echo Form::text('codigo', 'Código da venda'); ?>

                        </div>

                        <h4 class="mt-2">OU</h4>

                        <div class="col-md-12">
                            <?php echo Form::text('numero_nfce', 'Número NFCe'); ?>

                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">Fechar</button>
                    <button type="submit" class="btn btn-primary">Procurar</button>
                </div>
            </div>
        </form>
    </div>
</div>

<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.app', ['title' => 'Lista de trocas'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/trocas/index.blade.php ENDPATH**/ ?>