<?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
<div class="col-lg-4 col-12">
    <div class="card">
        <form method="get" <?php if(isset($item->is_cardapio)): ?> action="<?php echo e(route('pedido-cozinha.update-item', [$item->id])); ?>" <?php else: ?> action="<?php echo e(route('pedidos-delivery.update-item', [$item->id])); ?>" <?php endif; ?> id="form-<?php echo e($item->id); ?>">
            <div class="card-body" style="height: 320px">

                <?php if(isset($item->is_comanda)): ?>
                <h4 class="text-center">#<?php echo e($item->id); ?> <strong class="text-primary"><?php echo e($item->produto->nome); ?></strong></h4>
                <h3>Comanda: <strong class="text-danger "> <?php echo e($item->pedido->comanda); ?></strong></h3>
                <?php else: ?>
                <h4 class="text-center">#<?php echo e($item->id); ?> <strong class="text-primary"><?php echo e($item->produto->nome); ?></strong></h4>
                <h3>Pedido ID: <strong class="text-danger "> <?php echo e($item->pedido->id); ?></strong></h3>
                <?php endif; ?>
                <h5>Quantidade: <strong class="text-primary"> <?php echo e(number_format($item->quantidade, 2)); ?></strong></h5>
                <h5>Subtotal: <strong class="text-primary"> <?php echo e(__moeda($item->sub_total)); ?></strong></h5>
                <h5>Horário do pedido: <strong class="text-primary"> <?php echo e(\Carbon\Carbon::parse($item->created_at)->format('H:i:s')); ?></strong></h5>

                <h5>Adicionais: <strong class="text-primary"> <?php echo e(sizeof($item->adicionais) > 0 ? $item->getAdicionaisStr() : '--'); ?></strong></h5>
                <h5>Observação: <strong class="text-primary"> <?php echo e($item->observacao != '' ? $item->observacao : '--'); ?></strong></h5>
                <h5>Estado: 
                    <label class="text-<?php echo e($item->estado); ?>"><?php echo e(strtoupper($item->estado)); ?></label>
                </h5>

                <?php if($item->tempo_preparo > 0): ?>
                <h5>Horário que entrou em preparo: <strong class="text-primary"> <?php echo e(\Carbon\Carbon::parse($item->updated_at)->format('H:i:s')); ?></strong></h5>
                <h5>Tempo de preparo: <label class="text-info"><?php echo e($item->tempo_preparo); ?></label></h5>
                <?php if($item->tempoPreparoRestante() > -1): ?>
                <h5>Tempo de preparo restante: <label class="text-success"><?php echo e($item->tempoPreparoRestante()); ?> min</label></h5>
                <?php else: ?>
                <h5>Tempo de atraso para entrega: <label class="text-danger"><?php echo e($item->tempoPreparoRestante()*-1); ?> min</label></h5>
                <?php endif; ?>
                <?php endif; ?>

                <?php if(sizeof($item->pizzas) > 0): ?>
                <h5>Sabores: 
                    <?php $__currentLoopData = $item->pizzas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pizza): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <label class="text-danger"><?php echo e($pizza->sabor->nome); ?> <?php if(!$loop->last): ?> | <?php endif; ?></label>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </h5>

                <h5>Tamanho: <label class="text-danger"><?php echo e($item->tamanho->nome); ?></label></h5>
                <?php endif; ?>

                <?php if($item->ponto_carne): ?>
                <h5>Ponto da carne: <label class="text-danger"><?php echo e($item->ponto_carne); ?></label></h5>
                <?php endif; ?>

                <input type="hidden" name="estado" value="finalizado">
            </div>
            <div class="card-footer mt-2" style="height: 120px">
                <?php if($item->estado == 'pendente'): ?>
                <button type="button" class="btn btn-warning w-100" onclick="openModal()" data-bs-toggle="modal" data-bs-target="#modal-item-<?php echo e($item->id); ?>">Entrou em preparo</button>
                <?php endif; ?>
                <button type="submit" class="btn btn-success w-100 mt-1">Finalizado</button>
            </div>
        </form>
    </div>
</div>

<div class="modal fade" id="modal-item-<?php echo e($item->id); ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <form action="<?php echo e(route('pedido-cozinha.update-item', [$item->id])); ?>" method="get">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Item <strong class="text-primary"><?php echo e($item->produto->nome); ?></strong></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <input type="hidden" name="estado" value="preparando">
                        <div class="col-md-12">
                            <?php echo Form::text('tempo_preparo', 'Tempo de preparo')
                            ->attrs(['data-mask' => '000'])
                            ->value($item->produto->tempo_preparo); ?>

                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">Salvar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="row mb-4">
    <div class="col-md-3">
        <a href="<?php echo e(route('pedido-cozinha.update-all')); ?>" class="btn btn-danger">Finalizar todos os itens</a>
    </div>
</div>

<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
<div class="col-12">
    <div class="card">
        <div class="card-body">
            <h4 class="text-center">Nenhum item encontrado!</h4>
        </div>
    </div>
</div>
<?php endif; ?>
<?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/pedidos/partials/itens_pendentes.blade.php ENDPATH**/ ?>