<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-header">
                <h3>NFCe Lista Todas as Empresas</h3>
            </div>
            <div class="card-body">
                <div class="col-lg-12">
                    <?php echo Form::open()->fill(request()->all())
                    ->get(); ?>

                    <div class="row mt-3">
                        <div class="col-md-4">
                            <?php echo Form::select('empresa', 'Empresa')
                            ->attrs(['class' => 'select2'])
                            ->options($empresa != null ? [$empresa->id => $empresa->info] : []); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::date('start_date', 'Data inicial'); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::date('end_date', 'Data final'); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::select('estado', 'Estado',
                            ['novo' => 'Nova',
                            'rejeitado' => 'Rejeitadas',
                            'cancelado' => 'Canceladas',
                            'aprovado' => 'Aprovadas',
                            '' => 'Todos'])
                            ->attrs(['class' => 'select2']); ?>

                        </div>
                        <div class="col-md-2">
                            <br>
                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="<?php echo e(route('nfce-all')); ?>"><i class="ri-eraser-fill"></i> Limpar</a>

                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>
                <div class="col-lg-12 mt-3">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Empresa</th>
                                    <th>Cliente</th>
                                    <th>Número</th>
                                    <th>Valor</th>
                                    <th>Estado</th>
                                    <th>Ambiente</th>
                                    <th>Data</th>
                                    <th>Data de emissão</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($item->empresa->nome); ?> <?php echo e($item->empresa->cpf_cnpj); ?></td>
                                    <td><?php echo e($item->cliente ? $item->cliente->razao_social : ($item->cliente ? $item->cliente_nome : "--")); ?></td>
                                    <td><?php echo e($item->numero); ?></td>
                                    <td><?php echo e(number_format($item->total, 2, ',', '.')); ?></td>
                                    <td width="150">
                                        <?php if($item->estado == 'aprovado'): ?>
                                        <span class="btn btn-success text-white btn-sm w-100">aprovado</span>
                                        <?php elseif($item->estado == 'cancelado'): ?>
                                        <span class="btn btn-danger text-white btn-sm w-100">cancelado</span>
                                        <?php elseif($item->estado == 'rejeitado'): ?>
                                        <span class="btn btn-warning text-white btn-sm w-100">rejeitado</span>
                                        <?php else: ?>
                                        <span class="btn btn-info text-white btn-sm w-100">novo</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($item->ambiente == 2 ? 'Homologação' : 'Produção'); ?></td>

                                    <td><?php echo e(\Carbon\Carbon::parse($item->created_at)->format('d/m/Y H:i')); ?></td>
                                    <td><label style="width: 120px"><?php echo e($item->data_emissao ? __data_pt($item->data_emissao, 1) : '--'); ?></label></td>
                                    <td>
                                        <form action="<?php echo e(route('nfce.destroy', $item->id)); ?>" method="post" id="form-<?php echo e($item->id); ?>" style="width: 250px;">
                                            <?php if($item->estado == 'aprovado'): ?>
                                            <a class="btn btn-primary btn-sm" target="_blank" href="<?php echo e(route('nfce.imprimir', [$item->id])); ?>">
                                                <i class="ri-printer-line"></i>
                                            </a>

                                            <button title="Cancelar NFe" type="button" class="btn btn-danger btn-sm" onclick="cancelar('<?php echo e($item->id); ?>', '<?php echo e($item->numero); ?>')">
                                                <i class="ri-close-circle-line"></i>
                                            </button>
                                            <?php endif; ?>
                                            <?php if($item->estado == 'aprovado' || $item->estado == 'rejeitado'): ?>
                                            <button class="btn btn-dark btn-sm" onclick="info('<?php echo e($item->motivo_rejeicao); ?>', '<?php echo e($item->chave); ?>', '<?php echo e($item->estado); ?>', '<?php echo e($item->recibo); ?>')">
                                                <i class="ri-file-line"></i>
                                            </button>
                                            <?php endif; ?>
                                            <?php if($item->estado == 'novo' || $item->estado == 'rejeitado'): ?>
                                            <?php echo method_field('delete'); ?>
                                            <?php echo csrf_field(); ?>

                                            <?php endif; ?>
                                            <?php if($item->estado == 'novo' || $item->estado == 'rejeitado'): ?>
                                            <a target="_blank" title="XML temporário" class="btn btn-light btn-sm" href="<?php echo e(route('nfce.xml-temp', $item->id)); ?>">
                                                <i class="ri-file-line"></i>
                                            </a>
                                            <?php endif; ?>
                                        </form>

                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <?php echo $data->appends(request()->all())->links(); ?>

                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal-cancelar" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Cancelar NFCe <strong class="ref-numero"></strong></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">

                    <div class="col-md-12">
                        <?php echo Form::text('motivo-cancela', 'Motivo')
                        ->required(); ?>

                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-light" data-bs-dismiss="modal">Fechar</button>
                <button type="button" id="btn-cancelar" class="btn btn-danger">Cancelar</button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script type="text/javascript">
    function info(motivo_rejeicao, chave, estado, recibo) {

        if (estado == 'rejeitado') {
            let text = "Motivo: " + motivo_rejeicao + "\n"
            text += "Chave: " + chave + "\n"
            swal("", text, "warning")
        } else {
            let text = "Chave: " + chave + "\n"
            text += "Recibo: " + recibo + "\n"
            swal("", text, "success")
        }
    }

</script>
<script type="text/javascript" src="/js/nfce_transmitir.js"></script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['title' => 'NFCe Lista Geral'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/nfce/all.blade.php ENDPATH**/ ?>