<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-2">
                        <a href="<?php echo e(route('notificacao-super.create')); ?>" class="btn btn-success">
                            <i class="ri-add-circle-fill"></i>
                            Nova Notificação
                        </a>
                    </div>
                </div>
                <hr class="mt-3">
                <div class="col-lg-12">
                    <?php echo Form::open()->fill(request()->all())
                    ->get(); ?>

                    <div class="row mt-3">

                        <div class="col-md-4">
                            <?php echo Form::select('empresa', 'Empresa')
                            ->options($empresa != null ? [$empresa->id => $empresa->info] : []); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::date('start_date', 'Data inicial'); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::date('end_date', 'Data final'); ?>

                        </div>

                        <div class="col-md-2">
                            <?php echo Form::select('status', 'Status', ['' => 'Todos', '1' => 'Ativo', '0' => 'Desativado'])
                            ->attrs(['class' => 'form-select']); ?>

                        </div>

                        <div class="col-md-2">
                            <?php echo Form::select('prioridade', 'Prioridade', ['' => 'Todos', 'baixa' => 'Baixa', 'media' => 'Média', 'alta' => 'Alta'])
                            ->attrs(['class' => 'form-select']); ?>

                        </div>
                        
                        <div class="col-lg-4 col-12">
                            <br>
                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="<?php echo e(route('notificacao-super.index')); ?>"><i class="ri-eraser-fill"></i>Limpar</a>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>
                <div class="col-md-12 mt-3">
                    <div class="table-responsive">

                        <table class="table table-centered">
                            <thead class="table-dark">
                                <tr>
                                    <th>
                                        <div class="form-check form-checkbox-danger mb-2">
                                            <input class="form-check-input" type="checkbox" id="select-all-checkbox">
                                        </div>
                                    </th>
                                    <th>Empresa</th>
                                    <th>Título</th>
                                    <th>Descrição curta</th>
                                    <th>Status</th>
                                    <th>Visualizada</th>
                                    <th>Prioridade</th>
                                    <th>Data</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <div class="form-check form-checkbox-danger mb-2">
                                            <input class="form-check-input check-delete" type="checkbox" name="item_delete[]" value="<?php echo e($item->id); ?>">
                                        </div>
                                    </td>
                                    <td><?php echo e($item->empresa ? $item->empresa->info : "--"); ?></td>
                                    <td><?php echo e($item->titulo); ?></td>
                                    <td><?php echo e($item->descricao_curta); ?></td>
                                    <td>
                                        <?php if($item->status): ?>
                                        <i class="ri-checkbox-circle-fill text-success"></i>
                                        <?php else: ?>
                                        <i class="ri-close-circle-fill text-danger"></i>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($item->visualizada): ?>
                                        <i class="ri-checkbox-circle-fill text-success"></i>
                                        <?php else: ?>
                                        <i class="ri-close-circle-fill text-danger"></i>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e(strtoupper($item->prioridade)); ?></td>

                                    <td><?php echo e(__data_pt($item->created_at)); ?></td>
                                    <td width="300">
                                        <form action="<?php echo e(route('notificacao-super.destroy', $item->id)); ?>" method="post" id="form-<?php echo e($item->id); ?>">
                                            <?php echo method_field('delete'); ?>
                                            <?php echo csrf_field(); ?>
                                            <a class="btn btn-warning btn-sm" href="<?php echo e(route('notificacao-super.edit', $item->id)); ?>">
                                                <i class="ri-edit-line"></i>
                                            </a>
                                            <button type="button" class="btn btn-danger btn-sm btn-delete"><i class="ri-delete-bin-line"></i></button>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="8" class="text-center">Nada encontrado</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                        <form action="<?php echo e(route('notificacao-super.destroy-select')); ?>" method="post" id="form-delete-select">
                            <?php echo method_field('delete'); ?>
                            <?php echo csrf_field(); ?>
                            <div></div>
                            <button type="button" class="btn btn-danger btn-sm btn-delete-all" disabled>
                                <i class="ri-close-circle-line"></i> Remover selecionados
                            </button>
                        </form>
                        
                    </div>
                    <?php echo $data->appends(request()->all())->links(); ?>

                </div>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script type="text/javascript" src="/js/delete_selecionados.js"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['title' => 'Notificações'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/notificacao_super/index.blade.php ENDPATH**/ ?>