<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('boleto_create')): ?>
                <div class="col-12">
                    <a href="<?php echo e(route('remessa-boleto.index')); ?>" class="btn btn-success">
                        <i class="ri-file-list-2-fill"></i>
                        Remessas de boletos
                    </a>
                </div>
                <?php endif; ?>
                <hr class="mt-3">
                <div class="col-lg-12">
                    <?php echo Form::open()->fill(request()->all())
                    ->get(); ?>

                    <div class="row mt-3">
                        <div class="col-md-3">
                            <?php echo Form::select('cliente_id', 'Cliente')
                            ->attrs(['class' => 'select2'])
                            ->options($cliente != null ? [$cliente->id => $cliente->info] : []); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::date('start_date', 'Data inicial'); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::date('end_date', 'Data final'); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::select('banco', 'Pesquisar por banco', ['' => 'Selecione'] + $contasBoleto->pluck('info', 'id')->all())
                            ->attrs(['class' => 'form-select']); ?>

                        </div>
                        <div class="col-md-3 text-left ">
                            <br>
                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="<?php echo e(route('boleto.index')); ?>"><i class="ri-eraser-fill"></i>Limpar</a>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>
                <div class="col-md-12 mt-3">
                    <div class="table-responsive-sm">
                        <table class="table table-striped table-centered mb-0">
                            <thead class="table-dark">
                                <tr>

                                    <th>Banco</th>
                                    <th>Cliente</th>
                                    <th>Vencimento</th>
                                    <th>Status</th>
                                    <th>Valor</th>
                                    <th>Data de registro</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>

                                    <td><?php echo e($item->contaBoleto->banco); ?></td>
                                    <td><?php echo e($item->contaReceber->cliente->info); ?></td>
                                    <td><?php echo e(__data_pt($item->vencimento, 0)); ?></td>
                                    <td>
                                        <?php if($item->contaReceber->status): ?>
                                        <span class="btn btn-success position-relative me-lg-5 btn-sm">
                                            <i class="ri-checkbox-line"></i> Recebido
                                        </span>
                                        <?php else: ?>
                                        <span class="btn btn-warning position-relative me-lg-5 btn-sm">
                                            <i class="ri-alert-line"></i> Pendente
                                        </span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e(__moeda($item->valor)); ?></td>
                                    <td><?php echo e(__data_pt($item->created_at)); ?></td>
                                    <td>
                                        <form action="<?php echo e(route('boleto.destroy', $item->id)); ?>" method="post" id="form-<?php echo e($item->id); ?>">
                                            <?php echo method_field('delete'); ?>
                                            <?php echo csrf_field(); ?>
                                            <a target="_blank" title="Imprimir boleto" class="btn btn-dark btn-sm" href="<?php echo e(route('boleto.print', [$item->id])); ?>">
                                                <i class="ri-printer-line"></i>
                                            </a>
                                            <?php if(!$item->contaReceber->status): ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('conta_receber_edit')): ?>
                                            <a title="Receber conta" href="<?php echo e(route('conta-receber.pay', $item->contaReceber->id)); ?>" class="btn btn-success btn-sm text-white">
                                                <i class="ri-money-dollar-box-line"></i>
                                            </a>
                                            <?php endif; ?>
                                            
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('boleto_delete')): ?>
                                            <button type="button" class="btn btn-delete btn-sm btn-danger">
                                                <i class="ri-delete-bin-line"></i>
                                            </button>
                                            <?php endif; ?>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="7" class="text-center">Nada encontrado</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                        <br>
                        
                    </div>
                </div>
                <?php echo $data->appends(request()->all())->links(); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['title' => 'Boletos'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/boletos/index.blade.php ENDPATH**/ ?>