<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="col-md-2">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pdv_create')): ?>
                    <a href="<?php echo e(route('frontbox.create')); ?>" class="btn btn-success">
                        <i class="ri-add-circle-fill"></i>
                        PDV
                    </a>
                    <?php endif; ?>
                </div>
                <hr>
                <?php echo Form::open()->fill(request()->all())->get(); ?>

                <div class="row">
                    <div class="col-md-4">
                        <?php echo Form::select('cliente_id', 'Cliente')
                        ->attrs(['class' => 'select2']); ?>

                    </div>
                    <div class="col-md-2">
                        <?php echo Form::date('start_date', 'Data inicial'); ?>

                    </div>
                    <div class="col-md-2">
                        <?php echo Form::date('end_date', 'Data final'); ?>

                    </div>
                    <div class="col-md-3 text-left ">
                        <br>
                        <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                        <a id="clear-filter" class="btn btn-danger" href="<?php echo e(route('frontbox.index')); ?>"><i class="ri-eraser-fill"></i>Limpar</a>
                    </div>
                </div>
                <?php echo Form::close(); ?>


                <?php if($contigencia != null): ?>
                <div class="row">
                    <div class="col-md-3">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="text-danger">Contigência ativada</h4>
                                <p class="text-danger">Tipo: <strong><?php echo e($contigencia->tipo); ?></strong></p>
                                <p class="text-danger">Data de ínicio: <strong><?php echo e(__data_pt($contigencia->created_at)); ?></strong></p>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                <div class="col-lg-12 mt-4">
                    <div class="table-responsive">
                        <table class="table table-striped table-centered mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <th>#</th>
                                    <th>Cliente</th>
                                    <th>CPF/CNPJ</th>
                                    <th>Valor</th>
                                    <th>Estado</th>
                                    <th>Ambiente</th>
                                    <th>Número NFCe</th>
                                    <th>Data</th>
                                    <th>Lista de preço</th>
                                    <th>Usuário</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($item->numero_sequencial); ?></td>

                                    <td><label style="width: 350px"><?php echo e($item->cliente ? $item->cliente->razao_social : ($item->cliente_nome != "" ? $item->cliente_nome : "--")); ?></label></td>
                                    <td><label style="width: 150px"><?php echo e($item->cliente ? $item->cliente->cpf_cnpj : ($item->cliente_cpf_cnpj != "" ? $item->cliente_cpf_cnpj : "--")); ?></label></td>
                                    <td><?php echo e(__moeda($item->total)); ?></td>
                                    <td width="150">
                                        <?php if($item->estado == 'aprovado'): ?>
                                        <span class="btn btn-success text-white btn-sm w-100">aprovado</span>
                                        <?php elseif($item->estado == 'cancelado'): ?>
                                        <span class="btn btn-danger text-white btn-sm w-100">cancelado</span>
                                        <?php elseif($item->estado == 'rejeitado'): ?>
                                        <span class="btn btn-warning text-white btn-sm w-100">rejeitado</span>
                                        <?php else: ?>
                                        <span class="btn btn-info text-white btn-sm w-100">novo</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($item->ambiente == 2 ? 'Homologação' : 'Produção'); ?></td>
                                    <td><?php echo e($item->estado == 'aprovado' ? $item->numero : '--'); ?></td>
                                    <td><?php echo e(\Carbon\Carbon::parse($item->created_at)->format('d/m/Y H:i')); ?></td>
                                    <td><?php echo e($item->lista ? $item->listaPreco->nome : '--'); ?></td>
                                    <td><?php echo e($item->user ? $item->user->name : '--'); ?></td>
                                    <td>
                                        <form action="<?php echo e(route('frontbox.destroy', $item->id)); ?>" method="post" id="form-<?php echo e($item->id); ?>" style="width: 320px">
                                            <?php echo method_field('delete'); ?>
                                            <?php echo csrf_field(); ?>
                                            <a title="Imprimir não fiscal" class="btn btn-primary btn-sm" target="_blank" href="<?php echo e(route('frontbox.imprimir-nao-fiscal', [$item->id])); ?>">
                                                <i class="ri-printer-line"></i>
                                            </a>

                                            <!-- <a class="btn btn-warning btn-sm" href="<?php echo e(route('frontbox.edit', $item->id)); ?>">
                                                <i class="ri-edit-line"></i>
                                            </a> -->
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pdv_delete')): ?>
                                            <button type="button" class="btn btn-danger btn-sm btn-delete">
                                                <i class="ri-delete-bin-line"></i>
                                            </button>
                                            <?php endif; ?> 

                                            <?php if($item->estado == 'novo' || $item->estado == 'rejeitado'): ?>

                                            <button title="Transmitir NFCe" type="button" class="btn btn-success btn-sm" onclick="transmitir('<?php echo e($item->id); ?>')">
                                                <i class="ri-send-plane-fill"></i>
                                            </button>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pdv_edit')): ?>
                                            <a class="btn btn-warning btn-sm" title="Editar venda" href="<?php echo e(route('frontbox.edit', $item->id)); ?>"><i class="ri-pencil-line"></i></a>
                                            <?php endif; ?>

                                            <?php endif; ?>

                                            <a class="btn btn-ligth btn-sm" title="Detalhes" href="<?php echo e(route('frontbox.show', $item->id)); ?>"><i class="ri-eye-line"></i></a>
                                            <a target="_blank" title="XML temporário" class="btn btn-dark btn-sm" href="<?php echo e(route('nfce.xml-temp', $item->id)); ?>">
                                                <i class="ri-file-line"></i>
                                            </a>

                                            <?php if($item->estado == 'aprovado'): ?>
                                            <a class="btn btn-success btn-sm" title="Imprimir NFCe" target="_blank" href="<?php echo e(route('nfce.imprimir', [$item->id])); ?>">
                                                <i class="ri-printer-line"></i>
                                            </a>
                                            <?php endif; ?>

                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="11" class="text-center">Nada encontrado</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <br>
                    <?php echo $data->appends(request()->all())->links(); ?>

                </div>
                <h5 class="mt-2">Soma: <strong class="text-success">R$ <?php echo e(__moeda($data->sum('total'))); ?></strong></h5>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script type="text/javascript" src="/js/nfce_transmitir.js"></script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['title' => 'Lista de Vendas PDV'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/front_box/index.blade.php ENDPATH**/ ?>