<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">

                <hr class="mt-3">
                <div class="col-lg-12">
                    <?php echo Form::open()->fill(request()->all())
                    ->get(); ?>

                    <div class="row mt-3">
                        <div class="col-md-3">
                            <?php echo Form::select('funcionario_id', 'Funcionário')
                            ->options($funcionario != null ? [$funcionario->id => $funcionario->nome] : []); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::date('start_date', 'Data inicial'); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::date('end_date', 'Data final'); ?>

                        </div>

                        <div class="col-md-2">
                            <?php echo Form::select('status', 'Status', ['' => 'Todos', '0' => 'Pendente', '1' => 'Pago'])
                            ->attrs(['class' => 'form-select']); ?>

                        </div>
                        <div class="col-md-3 text-left">
                            <br>
                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="<?php echo e(route('comissao.index')); ?>"><i class="ri-eraser-fill"></i>Limpar</a>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>
                <div class="col-md-12 mt-3 table-responsive">
                    <div class="table-responsive-sm">
                        <form method="post" action="<?php echo e(route('comissao.pay-multiple')); ?>" id="form-comissao">
                            <?php echo csrf_field(); ?>
                            <button type="button" class="btn btn-success mb-1 btn-pay" disabled>
                                <i class="ri-wallet-fill"></i>
                                Pagar <strong class="total-pay">R$ 0,00</strong>
                            </button>
                            <table class="table table-striped table-centered mb-0">
                                <thead class="table-dark">
                                    <tr>
                                        <th>
                                            <input type="checkbox" class="select-all">
                                        </th>
                                        <th>Funcionário</th>
                                        <th>Tipo</th>
                                        <th>Status</th>
                                        <th>Valor da venda</th>
                                        <th>Valor da comissão</th>
                                        <th>Data</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td>
                                            <?php if(!$item->status): ?>
                                            <input type="checkbox" name="check[]" value="<?php echo e($item->id); ?>" class="select-check">
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($item->funcionario->nome); ?></td>
                                        <td><?php echo e($item->tabela == 'nfce' ? 'PDV' : 'Pedido'); ?></td>
                                        <td>
                                            <?php if($item->status): ?>
                                            <i class="ri-checkbox-circle-fill text-success"></i>
                                            <?php else: ?>
                                            <i class="ri-close-circle-fill text-danger"></i>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e(__moeda($item->valor_venda)); ?></td>
                                        <td><?php echo e(__moeda($item->valor)); ?></td>
                                        <td><?php echo e(__data_pt($item->created_at)); ?></td>

                                    </tr>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="7" class="text-center">Nada encontrado</td>
                                    </tr>
                                    <?php endif; ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td colspan="3"></td>
                                        <td class="text-primary">R$ <?php echo e(__moeda($data->sum('valor_venda'))); ?></td>
                                        <td class="text-primary">R$ <?php echo e(__moeda($data->sum('valor'))); ?></td>
                                        <td colspan="2"></td>

                                    </tr>
                                </tfoot>
                            </table>

                            <?php echo $__env->make('modals._modal_conta_pagar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            
                        </form>
                    </div>
                </div>

                <br>
                <div class="row">
                    <div class="col-lg-4 col-12">
                        <h4>Total de comissões pendentes: <strong class="text-danger">R$ <?php echo e(__moeda($sumComissaoPendente)); ?></strong></h4>
                    </div>

                    <div class="col-lg-4 col-12">
                        <h4>Total de comissões pagas: <strong class="text-success">R$ <?php echo e(__moeda($sumComissaoPago)); ?></strong></h4>
                    </div>
                    <div class="col-lg-4 col-12">
                        <h4>Total de vendas: <strong class="text-success">R$ <?php echo e(__moeda($sumVendas)); ?></strong></h4>
                    </div>
                </div>

                <?php echo $data->appends(request()->all())->links(); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script type="text/javascript" src="/js/comissao.js"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['title' => 'Comissão de Vendas'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/comissao_venda/index.blade.php ENDPATH**/ ?>