<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="col-md-2">
                    <a href="<?php echo e(route('produtos.create', ['ecommerce=1'])); ?>" class="btn btn-success">
                        <i class="ri-add-circle-fill"></i>
                        Novo Produto Ecommerce
                    </a>
                </div>
                <hr class="mt-3">
                <div class="col-lg-12">
                    <?php echo Form::open()->fill(request()->all())
                    ->get(); ?>

                    <div class="row mt-3">
                        <div class="col-md-4">
                            <?php echo Form::text('nome', 'Pesquisar por nome'); ?>

                        </div>

                        <div class="col-md-2">
                            <?php echo Form::select('status', 'Status', ['' => 'Todos', '1' => 'Ativos', '0' => 'Desativados'])
                            ->attrs(['class' => 'form-select']); ?>

                        </div>
                        <div class="col-md-3 text-left">
                            <br>
                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="<?php echo e(route('produtos-ecommerce.index')); ?>"><i class="ri-eraser-fill"></i>Limpar</a>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>
                <div class="col-md-12 mt-3 table-responsive">
                    <div class="table-responsive-sm">
                        <table class="table table-striped table-centered mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <th></th>
                                    <th>Nome</th>
                                    <th>Unidade</th>
                                    <th>Categoria</th>
                                    <th>Gerenciar estoque</th>
                                    <th>Status</th>
                                    <th>Valor</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><img class="img-60" src="<?php echo e($item->img); ?>"></td>
                                    <td width="300"><?php echo e($item->nome); ?></td>
                                    <td><?php echo e($item->unidade); ?></td>
                                    <td><?php echo e($item->categoria ? $item->categoria->nome : '--'); ?></td>
                                    <td>
                                        <?php if($item->gerenciar_estoque): ?>
                                        <i class="ri-checkbox-circle-fill text-success"></i>
                                        <?php else: ?>
                                        <i class="ri-close-circle-fill text-danger"></i>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($item->status): ?>
                                        <i class="ri-checkbox-circle-fill text-success"></i>
                                        <?php else: ?>
                                        <i class="ri-close-circle-fill text-danger"></i>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php echo e(__moeda($item->valor_ecommerce)); ?>

                                    </td>
                                    <td>
                                        <form action="<?php echo e(route('produtos.destroy', $item->id)); ?>" method="post" id="form-<?php echo e($item->id); ?>">
                                            <?php echo method_field('delete'); ?>
                                            <a class="btn btn-warning btn-sm" href="<?php echo e(route('produtos.edit', [$item->id, 'ecommerce=1'])); ?>" title="Editar">
                                                <i class="ri-edit-line"></i>
                                            </a>

                                            <?php echo csrf_field(); ?>
                                            <button type="button" class="btn btn-delete btn-sm btn-danger">
                                                <i class="ri-delete-bin-line"></i>
                                            </button>

                                            <a title="Galeria" class="btn btn-dark btn-sm" href="<?php echo e(route('produtos.galeria', [$item->id, 'ecommerce=1'])); ?>">
                                                <i class="ri-image-2-fill"></i>
                                            </a>

                                            <a class="btn btn-primary btn-sm" href="<?php echo e(route('produtos.duplicar', [$item->id, 'ecommerce=1'])); ?>" title="Duplicar produto">
                                                <i class="ri-file-copy-line"></i>
                                            </a>
                                        </form>

                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="8" class="text-center">Nada encontrado</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php echo $data->appends(request()->all())->links(); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['title' => 'Produtos de Ecommerce'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/ecommerce/produtos/index.blade.php ENDPATH**/ ?>