<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div style="text-align: right; margin-top: -5px;">

                    <a href="<?php echo e(route('config-api.index')); ?>" class="btn btn-danger btn-sm px-3">
                        <i class="ri-arrow-left-double-fill"></i>Voltar
                    </a>
                </div>
                <hr class="mt-3">
                <div class="col-lg-12">
                    <?php echo Form::open()->fill(request()->all())
                    ->get(); ?>

                    <div class="row mt-3">
                        <div class="col-md-2">
                            <?php echo Form::select('status', 'Status', ['' => 'Todos', 'sucesso' => 'Sucesso', 'erro' => 'Erro'])
                            ->attrs(['class' => 'form-select']); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::select('tipo', 'Tipo', ['' => 'Todos'] + App\Models\ApiConfig::acoes())
                            ->attrs(['class' => 'form-select']); ?>

                        </div>
                        <div class="col-md-3">
                            <?php echo Form::select('prefixo', 'Local', ['' => 'Todos'] + App\Models\ApiConfig::permissoes())
                            ->attrs(['class' => 'select2']); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::date('start_date', 'Data inicial'); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::date('end_date', 'Data final'); ?>

                        </div>
                        <div class="col-md-3 text-left ">
                            <br>
                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="<?php echo e(route('config-api.logs')); ?>"><i class="ri-eraser-fill"></i>Limpar</a>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>
                <div class="col-md-12 mt-3 table-responsive">
                    <div class="table-responsive-sm">
                        <table class="table table-striped table-centered mb-0">
                            <thead class="table-dark">
                                <tr>

                                    <th>Token</th>
                                    <th>Data</th>
                                    <th>Status</th>
                                    <th>Tipo</th>
                                    <th>Descrição</th>
                                    <th>Local</th>
                                    
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>

                                    <td><?php echo e($item->token); ?></td>
                                    <td><?php echo e(__data_pt($item->created_at)); ?></td>

                                    <td>
                                        <?php if($item->status == 'sucesso'): ?>
                                        <i class="ri-checkbox-circle-fill text-success"></i>
                                        <?php else: ?>
                                        <i class="ri-close-circle-fill text-danger"></i>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($item->getTipo()); ?></td>
                                    <td><?php echo e($item->descricao); ?></td>
                                    <td><?php echo e($item->getPrefixo()); ?></td>

                                    
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="6" class="text-center">Nada encontrado</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <br>
                <?php echo $data->appends(request()->all())->links(); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script type="text/javascript" src="/js/delete_selecionados.js"></script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', ['title' => 'Logs da API'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/api_config/logs.blade.php ENDPATH**/ ?>