<?php $__env->startSection('content'); ?>

<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <h4>Dias da semana</h4>
                <hr>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('atendimentos_create')): ?>
                <a class="btn btn-success px-3" href="<?php echo e(route('atendimentos.create')); ?>">
                    <i class="ri-add-circle-fill"></i>
                    Cadastrar
                </a>
                <?php endif; ?>

                <div class="col-lg-12">
                    <?php echo Form::open()->fill(request()->all())
                    ->get(); ?>

                    <div class="row mt-3">
                        <div class="col-md-4">
                            <?php echo Form::select('funcionario_id', 'Funcionário', ['' => 'Selecione'] + $funcionarios->pluck('nome', 'id')->all())
                            ->attrs(['class' => 'select2']); ?>

                        </div>
                        
                        <div class="col-lg-4 col-12">
                            <br>

                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="<?php echo e(route('atendimentos.index')); ?>"><i class="ri-eraser-fill"></i>Limpar</a>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>

                <div class="table-responsive-sm mt-3">
                    <table class="table table-striped table-centered mb-0">
                        <thead class="table-dark">
                            <tr>
                                <th>Funucionário</th>
                                <th>Dias</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($item->funcionario->nome); ?></td>
                                <td><?php echo e($item->diaStr()); ?></td>
                                <td>
                                    <form action="<?php echo e(route('atendimentos.destroy', $item->id)); ?>" method="post" id="form-<?php echo e($item->id); ?>">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('delete'); ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('atendimentos_edit')): ?>
                                        <a class="btn btn-warning btn-sm" href="<?php echo e(route('atendimentos.edit', [$item->id])); ?>">
                                            <i class="ri-pencil-fill"></i>
                                        </a>
                                        <?php endif; ?>
                                        
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('atendimentos_delete')): ?>
                                        <button type="submit" title="Deletar" class="btn btn-danger btn-sm btn-delete"><i class="ri-delete-bin-2-line"></i></button>
                                        <?php endif; ?>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="3" class="text-center">Nada encontrado</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['title' => 'Dias da semana'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/atendimentos/index.blade.php ENDPATH**/ ?>