<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">

                <hr class="mt-3">
                <div class="col-lg-12">
                    <?php echo Form::open()->fill(request()->all())
                    ->get(); ?>

                    <div class="row mt-3">
                        <div class="col-md-3">
                            <?php echo Form::select('usuario_id', 'Pesquisar por usuário', ['' => 'Selecione'] + $usuarios->pluck('name', 'id')->all())
                            ->attrs(['class' => 'select2']); ?>

                        </div>
                        
                        <div class="col-md-3 text-left ">
                            <br>
                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="<?php echo e(route('tef-registros.index')); ?>"><i class="ri-eraser-fill"></i>Limpar</a>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>
                <div class="col-md-12 mt-3">
                    <div class="table-responsive-sm">
                        <table class="table table-striped table-centered mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <th>Data</th>
                                    <th>Hora</th>
                                    <th>Venda</th>
                                    <th>Valor</th>
                                    <th>NSU</th>
                                    <th width="10%">Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($item->getDataTransacao()); ?></td>
                                    <td><?php echo e($item->getHoraTransacao()); ?></td>
                                    <td><?php echo e($item->nfce_id); ?></td>
                                    <td><?php echo e(__moeda($item->valor_total/100)); ?></td>
                                    <td><?php echo e($item->nsu); ?></td>

                                    <td>

                                        <button type="button" class="btn btn-sm btn-danger" onclick="cancelar('<?php echo e($item->id); ?>')">
                                            <i class="ri-close-line"></i>
                                        </button>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="6" class="text-center">Nada encontrado</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php echo $data->appends(request()->all())->links(); ?>


            </div>
        </div>
    </div>
</div>
<?php echo $__env->make('modals._tef_consulta', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script type="text/javascript">
    function cancelar(id){

        swal({
            title: "Você está certo?",
            text: "Você está prestes a estornar o valor da venda!",
            icon: "warning",
            buttons: true,
            buttons: ["Cancelar", "Estornar"],
            dangerMode: true,
        }).then((isConfirm) => {
            if (isConfirm) {

                $.post(path_url + "api/tef/cancelar",
                {
                    id: id,
                })
                .done((data) => {
                    console.log(data)
                    consultaCancelamento(data)
                })
                .fail((e) => {
                    console.log(e)
                });
            } else {
                swal("", "Este item está salvo!", "info");
            }
        });
    }

    function consultaCancelamento(hash){
        $('#modal_tef_consulta').modal('show')
        $('.status-tef').text('Processando')
        $('.loading-tef').removeClass('d-none')

        let data = {
            hash: hash,
            usuario_id: $('#usuario_id').val(),
            empresa_id: $('#empresa_id').val()
        }
        $('.modal-loading').remove()
        let intervalo = null;
        intervalo = setInterval(() => {
            $.post(path_url + 'api/tef/consulta-cancelamento', data)
            .done((success) => {
                console.log(success)
                
            })
            .fail((err) => {
                console.log(err)
                clearInterval(intervalo)
                $('.status-tef').text(err.responseJSON)
                setTimeout(() => {
                    $('#modal_tef_consulta').modal('hide')
                }, 2000)
            })
        }, 3000)
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', ['title' => 'TEF Registros'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/tef_registro/index.blade.php ENDPATH**/ ?>