<?php $__env->startSection('content'); ?>

<div class="card mt-1">
    <div class="card-body">
        <div class="pl-lg-4">
            <?php echo Form::open()
            ->post()
            ->route('ordem-servico.update-estado', [$ordem->id]); ?>

            <?php echo csrf_field(); ?>
            <div class="col-sm-12 col-lg-12 col-md-12 col-xl-12">
                <h5>Estado Atual:
                    <?php if($ordem->estado == 'pd'): ?>
                    <span class="btn btn-warning btn-sm">PENDENTE</span>
                    <?php elseif($ordem->estado == 'ap'): ?>
                    <span class="btn btn-success btn-sm">APROVADO</span>
                    <?php elseif($ordem->estado == 'rp'): ?>
                    <span class="btn btn-danger btn-sm">REPROVADO</span>
                    <?php else: ?>
                    <span class="btn btn-info btn-sm">FINALIZADO</span>
                    <?php endif; ?>
                </h5>


                <?php if($ordem->estado != 'fz' && $ordem->estado != 'rp'): ?>

                <div class="row">
                    <div class=" col-md-2">
                        <label>Estado</label>
                        <?php if($ordem->estado == 'pd'): ?>
                        <select required class="form-select" id="estado" name="novo_estado">
                            <option value="ap">APROVADO</option>
                            <option value="rp">REPROVADO</option>
                        </select>
                        <?php elseif($ordem->estado == 'ap'): ?>
                        <select class="form-select" id="estado" name="novo_estado">
                            <option value="fz">FINALIZADO</option>
                        </select>
                        <?php endif; ?>
                    </div>

                    <div class="col-md-2 d-none div-fatura">
                        <?php echo Form::select('faturar', 'Gerar faturamento', [0 => 'Não', 1 => 'Sim'])
                        ->attrs(['class' => 'form-select'])->required(); ?>

                    </div>
                    <div class="form-group validated col-sm-4 col-lg-4">
                        <br>
                        <button type="submit" class="btn btn-success px-5">Alterar</button>
                    </div>
                </div>

                <?php elseif($ordem->estado == 'fz'): ?>
                <h5 class="text-success">Ordem de serviço finalizada!</h5>

                <div style="text-align: right; margin-top: -35px;">
                    <a href="<?php echo e(route('ordem-servico.show', [$ordem->id])); ?>" class="btn btn-danger btn-sm px-3">
                        <i class="ri-arrow-left-double-fill"></i>Voltar
                    </a>
                </div>
                <?php else: ?>
                <h5 class="text-danger">Ordem de serviço reprovada!</h5>
                <div style="text-align: right; margin-top: -35px;">
                    <a href="<?php echo e(route('ordem-servico.show', [$ordem->id])); ?>" class="btn btn-danger btn-sm px-3">
                        <i class="ri-arrow-left-double-fill"></i>Voltar
                    </a>
                </div>
                <?php endif; ?>

                
            </div>
            <?php echo Form::close(); ?>

        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script type="text/javascript">
    $(function(){
        changeEstado()
    })

    $('#estado').change(() => {
        changeEstado()
    })

    function changeEstado(){
        let estado = $('#estado').val()
        if(estado == 'fz'){
            $('.div-fatura').removeClass('d-none')
        }else{
            $('.div-fatura').addClass('d-none')
        }
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', ['title' => 'Alterar estado'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/ordem_servico/alterar_estado.blade.php ENDPATH**/ ?>