<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="col-md-12">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('localizacao_create')): ?>
                    <a href="<?php echo e(route('localizacao.create')); ?>" class="btn btn-success">
                        <i class="ri-add-circle-fill"></i>
                        Nova Localização
                    </a>
                    <?php endif; ?>

                </div>

                <div class="col-md-12 mt-3 table-responsive">
                    <div class="table-responsive-sm">
                        <table class="table table-striped table-centered mb-0">
                            <thead class="table-dark">
                                <tr>
                                    
                                    <th>Descrição</th>
                                    <th>Razão Social/Nome</th>
                                    <th>CPF/CNPJ</th>
                                    <th>Cidade</th>
                                    <th>Endereço</th>
                                    <th>CEP</th>
                                    <th>Status</th>
                                    <th width="10%">Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    
                                    <td><?php echo e($item->descricao); ?></td>
                                    <td width="400"><?php echo e($item->nome); ?></td>
                                    <td><?php echo e($item->cpf_cnpj); ?></td>
                                    <td><?php echo e($item->cidade ? $item->cidade->info : ''); ?></td>
                                    <td><?php echo e($item->rua ? $item->endereco : '--'); ?></td>
                                    <td><?php echo e($item->cep); ?></td>
                                    <td>
                                        <?php if($item->status): ?>
                                        <i class="ri-checkbox-circle-fill text-success"></i>
                                        <?php else: ?>
                                        <i class="ri-close-circle-fill text-danger"></i>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <form action="<?php echo e(route('localizacao.destroy', $item->id)); ?>" method="post" id="form-<?php echo e($item->id); ?>" style="width: 150px;">
                                            <?php echo method_field('delete'); ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('localizacao_edit')): ?>
                                            <a class="btn btn-warning btn-sm" href="<?php echo e(route('localizacao.edit', [$item->id])); ?>">
                                                <i class="ri-pencil-fill"></i>
                                            </a>
                                            <?php endif; ?>

                                            <?php echo csrf_field(); ?>
                                            <?php if(!$loop->first): ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('localizacao_delete')): ?>
                                            <button type="button" class="btn btn-delete btn-sm btn-danger">
                                                <i class="ri-delete-bin-line"></i>
                                            </button>
                                            <?php endif; ?>
                                            <?php endif; ?>

                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="8" class="text-center">Nada encontrado</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                        <br>
                        
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', ['title' => 'Localizações'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/localizacao/index.blade.php ENDPATH**/ ?>