<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="d-flex flex-wrap gap-2">
                    <div class="">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('apuracao_mensal_create')): ?>
                        <a href="<?php echo e(route('apuracao-mensal.create')); ?>" class="btn btn-success">
                            <i class="ri-add-circle-fill"></i>
                            Nova Apuração
                        </a>
                        <?php endif; ?>
                    </div>
                </div>
                <hr class="mt-3">
                <div class="col-lg-12">
                    <?php echo Form::open()->fill(request()->all())
                    ->get(); ?>

                    <div class="row mt-3">
                        <div class="col-md-3">
                            <?php echo Form::select('funcionario_id', 'Pesquisar funcionário')
                            ->options($funcionario ? [$funcionario->id => $funcionario->nome] : []); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::date('start_date', 'Data inicial'); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::date('end_date', 'Data final'); ?>

                        </div>
                        <div class="col-md-3 text-left">
                            <br>
                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="<?php echo e(route('apuracao-mensal.index')); ?>"><i class="ri-eraser-fill"></i>Limpar</a>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>
                <div class="col-12 mt-3">
                    <div class="table-responsive-sm">
                        <table class="table table-striped table-centered mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <th>Funcionário</th>
                                    <th>Data Registro</th>
                                    <th>Valor Final</th>
                                    <th>Mês/Ano</th>
                                    <th>Adicionado em Contas a Pagar</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($item->funcionario->nome); ?></td>
                                    <td><?php echo e(__data_pt($item->created_at)); ?></td>
                                    <td><?php echo e(__moeda($item->valor_final)); ?></td>
                                    <td><?php echo e($item->mes); ?>/<?php echo e($item->ano); ?></td>
                                    <td>
                                        <?php if($item->conta_pagar_id == 0): ?>
                                        <i class="ri-close-circle-fill text-danger"></i>
                                        <?php else: ?>
                                        <i class="ri-checkbox-circle-fill text-success"></i>
                                        <a class="btn btn-sm btn-dark" target="_blank" href="/conta-pagar/<?php echo e($item->conta_pagar_id); ?>/edit">
                                            ver conta
                                        </a>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <form action="<?php echo e(route('apuracao-mensal.destroy', $item->id)); ?>" method="post" id="form-<?php echo e($item->id); ?>">
                                            <?php echo method_field('delete'); ?>

                                            <?php if(!$item->conta_pagar_id): ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('conta_pagar_create')): ?>
                                            <a class="btn btn-warning btn-sm" href="<?php echo e(route('apuracao-mensal.conta-pagar', [$item->id])); ?>">
                                                <i class="ri-money-dollar-box-line"></i>
                                            </a>
                                            <?php endif; ?>

                                            <?php endif; ?>

                                            <?php echo csrf_field(); ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('apuracao_mensal_delete')): ?>
                                            <button type="button" class="btn btn-delete btn-sm btn-danger">
                                                <i class="ri-delete-bin-line"></i>
                                            </button>
                                            <?php endif; ?>

                                            <a class="btn btn-dark btn-sm" href="<?php echo e(route('apuracao-mensal.show', [$item->id])); ?>">
                                                <i class="ri-printer-line"></i>
                                            </a>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="7" class="text-center">Nada encontrado</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php echo $data->appends(request()->all())->links(); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', ['title' => 'Apuração Mensal'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/apuracao_mensal/index.blade.php ENDPATH**/ ?>